/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.file.BlockFileUtils;
import io.questdb.cairo.file.ReadableBlock;
import io.questdb.cairo.vm.MemoryCARWImpl;
import io.questdb.cairo.vm.MemoryCMRImpl;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.std.BinarySequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Utf8Sequence;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class BlockFileReader
implements Closeable {
    private final BlockCursor blockCursor = new BlockCursor();
    @NotNull
    private final MillisecondClock clock;
    private final FilesFacade ff;
    private final long spinLockTimeoutMs;
    private MemoryCMR file;
    private MemoryCR memory;

    public BlockFileReader(CairoConfiguration configuration) {
        this.ff = configuration.getFilesFacade();
        this.spinLockTimeoutMs = configuration.getSpinLockTimeout();
        this.clock = configuration.getMillisecondClock();
    }

    @Override
    public void close() {
        Misc.free(this.memory);
        Misc.free(this.file);
    }

    public BlockCursor getCursor() {
        int expectedChecksum;
        long checksumSize;
        long regionLength;
        long currentVersion;
        long deadline = this.clock.getTicks() + this.spinLockTimeoutMs;
        while (true) {
            long regionOffset;
            if ((regionOffset = 40L + this.file.getLong(BlockFileUtils.getRegionOffsetOffset(currentVersion = this.getVersionVolatile()))) + (regionLength = this.file.getLong(BlockFileUtils.getRegionLengthOffset(currentVersion))) > this.file.size()) {
                this.file.extend(regionOffset + regionLength);
            }
            long fileBaseAddress = this.file.getPageAddress(0);
            long memoryBaseAddress = this.memory.resize(regionLength);
            Vect.memcpy(memoryBaseAddress, fileBaseAddress + regionOffset, regionLength);
            if (currentVersion == this.getVersionVolatile()) break;
            if (this.clock.getTicks() > deadline) {
                throw CairoException.critical(0).put("block file read timeout [timeout=").put(this.spinLockTimeoutMs).put("ms, fd=").put(this.file.getFd()).put(']');
            }
            Os.pause();
        }
        long memoryBaseAddress = this.memory.getPageAddress(0);
        long checksumAddress = memoryBaseAddress + 8L + 4L;
        int checksum = BlockFileUtils.checksum(checksumAddress, checksumSize = regionLength - 8L - 4L);
        if (checksum != (expectedChecksum = this.memory.getInt(0L))) {
            throw CairoException.critical(0).put("block file checksum mismatch [expected=").put(expectedChecksum).put(", actual=").put(checksum).put(", fd=").put(this.file.getFd()).put(']');
        }
        int blockCount = this.memory.getInt(4L);
        assert (blockCount > 0);
        long blocksLength = regionLength - 8L;
        this.blockCursor.of(currentVersion, blockCount, 8L, blocksLength);
        return this.blockCursor;
    }

    public void of(LPSZ path) {
        this.close();
        long pageSize = this.ff.getPageSize();
        if (!this.ff.exists(path)) {
            throw CairoException.fileNotFound().put("cannot open block file [path=").put(path).put(']');
        }
        long fileLen = this.ff.length(path);
        if (fileLen < 40L) {
            throw CairoException.critical(0).put("block file too small [expected=").put(40L).put(", actual=").put(fileLen).put(", path=").put(path).put(']');
        }
        if (this.file == null) {
            this.file = new MemoryCMRImpl();
        }
        this.file.of(this.ff, path, pageSize, this.ff.length(path), 0);
        long version = this.getVersionVolatile();
        if (version == 0L) {
            throw CairoException.critical(0).put("cannot read block file, expected at least 1 commited data block [path=").put(path).put(']');
        }
        if (this.memory == null) {
            this.memory = new MemoryCARWImpl(pageSize, Integer.MAX_VALUE, 19);
        }
    }

    private long getVersionVolatile() {
        return Unsafe.getUnsafe().getLongVolatile(null, this.file.getPageAddress(0) + 0L);
    }

    public class BlockCursor {
        private final Block block = new Block();
        private int blockCount;
        private long blocksLimit;
        private long currentBlockOffset;
        private long regionVersion;

        public long getRegionVersion() {
            return this.regionVersion;
        }

        public boolean hasNext() {
            if (this.blockCount > 0 && this.currentBlockOffset < this.blocksLimit) {
                int blockLength = BlockFileReader.this.memory.getInt(this.currentBlockOffset + 0L);
                return blockLength > 0 && this.currentBlockOffset + (long)blockLength <= this.blocksLimit;
            }
            return false;
        }

        public ReadableBlock next() {
            int blockLength = BlockFileReader.this.memory.getInt(this.currentBlockOffset + 0L);
            int type = BlockFileReader.this.memory.getInt(this.currentBlockOffset + 4L);
            this.block.of(blockLength, type, this.currentBlockOffset);
            this.currentBlockOffset += (long)blockLength;
            --this.blockCount;
            return this.block;
        }

        public void of(long regionVersion, int blockCount, long blocksOffset, long blocksLength) {
            this.regionVersion = regionVersion;
            this.blockCount = blockCount;
            this.blocksLimit = blocksOffset + blocksLength;
            this.currentBlockOffset = blocksOffset;
        }

        private class Block
        implements ReadableBlock {
            private int length;
            private long payloadOffset;
            private int type;

            private Block() {
            }

            @Override
            public long addressOf(long offset) {
                return BlockFileReader.this.memory.addressOf(this.payloadOffset + offset);
            }

            @Override
            public BinarySequence getBin(long offset) {
                return BlockFileReader.this.memory.getBin(this.payloadOffset + offset);
            }

            @Override
            public boolean getBool(long offset) {
                return BlockFileReader.this.memory.getBool(this.payloadOffset + offset);
            }

            @Override
            public byte getByte(long offset) {
                return BlockFileReader.this.memory.getByte(this.payloadOffset + offset);
            }

            @Override
            public char getChar(long offset) {
                return BlockFileReader.this.memory.getChar(this.payloadOffset + offset);
            }

            @Override
            public double getDouble(long offset) {
                return BlockFileReader.this.memory.getDouble(this.payloadOffset + offset);
            }

            @Override
            public float getFloat(long offset) {
                return BlockFileReader.this.memory.getFloat(this.payloadOffset + offset);
            }

            @Override
            public int getInt(long offset) {
                return BlockFileReader.this.memory.getInt(this.payloadOffset + offset);
            }

            @Override
            public long getLong(long offset) {
                return BlockFileReader.this.memory.getLong(this.payloadOffset + offset);
            }

            @Override
            public short getShort(long offset) {
                return BlockFileReader.this.memory.getShort(this.payloadOffset + offset);
            }

            @Override
            public CharSequence getStr(long offset) {
                return BlockFileReader.this.memory.getStrA(this.payloadOffset + offset);
            }

            @Override
            public Utf8Sequence getVarchar(long offset) {
                return VarcharTypeDriver.getPlainValue(BlockFileReader.this.memory, this.payloadOffset + offset);
            }

            @Override
            public long length() {
                return this.length;
            }

            public void of(int length, int type, long blockOffset) {
                this.length = length;
                this.type = type;
                this.payloadOffset = blockOffset + 8L;
            }

            @Override
            public int type() {
                return this.type;
            }
        }
    }
}

