/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.AbstractPool;
import io.questdb.cairo.pool.PoolConstants;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.pool.ResourcePool;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.pool.ex.PoolClosedException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiTenantPool<T extends PoolTenant<T>>
extends AbstractPool
implements ResourcePool<T> {
    public static final int ENTRY_SIZE = 32;
    public static final String NO_LOCK_REASON = "unknown";
    private static final long LOCK_OWNER = Unsafe.getFieldOffset(Entry.class, "lockOwner");
    private static final int NEXT_ALLOCATED = 1;
    private static final int NEXT_LOCKED = 2;
    private static final int NEXT_OPEN = 0;
    private static final long NEXT_STATUS = Unsafe.getFieldOffset(Entry.class, "nextStatus");
    private static final long UNLOCKED = -1L;
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final ConcurrentHashMap<Entry<T>> entries = new ConcurrentHashMap();
    private final int maxEntries;
    private final int maxSegments;
    private final ThreadLocal<ResourcePoolSupervisor<T>> threadLocalPoolSupervisor = new ThreadLocal();

    public AbstractMultiTenantPool(CairoConfiguration configuration, int maxSegments, long inactiveTtlMillis) {
        super(configuration, inactiveTtlMillis);
        this.maxSegments = maxSegments;
        this.maxEntries = maxSegments * 32;
    }

    public void configureThreadLocalPoolSupervisor(@NotNull ResourcePoolSupervisor<T> poolSupervisor) {
        this.threadLocalPoolSupervisor.set(poolSupervisor);
    }

    public Map<CharSequence, Entry<T>> entries() {
        return this.entries;
    }

    @Override
    public T get(TableToken tableToken) {
        return this.get0(tableToken, null);
    }

    public int getBusyCount() {
        int count = 0;
        for (Map.Entry<CharSequence, Entry<T>> me : this.entries.entrySet()) {
            Entry<T> e = me.getValue();
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.arrayGetVolatile(e.allocations, i) == -1L || e.getTenant(i) == null) continue;
                    ++count;
                }
            } while ((e = e.next) != null);
        }
        return count;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean isCopyOfSupported() {
        return false;
    }

    public boolean lock(TableToken tableToken) {
        long thread;
        Entry<T> e = this.getEntry(tableToken);
        if (Unsafe.cas(e, LOCK_OWNER, -1L, thread = Thread.currentThread().getId()) || e.lockOwner == thread) {
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.cas(e.allocations, i, -1L, thread)) {
                        this.closeTenant(thread, e, i, (short)19, 2);
                        continue;
                    }
                    if (Unsafe.arrayGetVolatile(e.allocations, i) == thread) {
                        if (e.getTenant(i) == null) continue;
                        e.lockOwner = -1L;
                        return false;
                    }
                    this.LOG.info().$("could not lock, busy [table=").$(tableToken).$(", at=").$(e.index).$(':').$(i).$(", owner=").$(e.allocations[i]).$(", thread=").$(thread).I$();
                    e.lockOwner = -1L;
                    return false;
                }
                if (e.next != null) continue;
                if (!Unsafe.getUnsafe().compareAndSwapInt(e, NEXT_STATUS, 0, 2)) {
                    if (e.nextStatus != 1) continue;
                    while (e.next == null) {
                        Os.pause();
                    }
                }
                break;
            } while ((e = e.next) != null);
        } else {
            this.LOG.error().$("already locked [table=").$(tableToken).$(", owner=").$(e.lockOwner).I$();
            this.notifyListener(thread, tableToken, (short)7, -1, -1);
            return false;
        }
        this.notifyListener(thread, tableToken, (short)6, -1, -1);
        this.LOG.debug().$("locked [table=").$(tableToken).$(", thread=").$(thread).I$();
        return true;
    }

    public void removeThreadLocalPoolSupervisor() {
        this.threadLocalPoolSupervisor.remove();
    }

    public void unlock(TableToken tableToken) {
        Entry<T> e = this.entries.get(tableToken.getDirName());
        long thread = Thread.currentThread().getId();
        if (e == null) {
            this.LOG.info().$("not found, cannot unlock [table=").$(tableToken).I$();
            this.notifyListener(thread, tableToken, (short)9, -1, -1);
            return;
        }
        if (e.lockOwner == thread) {
            this.entries.remove(tableToken.getDirName());
            while (e != null) {
                e = e.next;
            }
        } else {
            this.notifyListener(thread, tableToken, (short)12);
            throw CairoException.nonCritical().put("Not the lock owner of ").put(tableToken.getDirName());
        }
        this.notifyListener(thread, tableToken, (short)8, -1, -1);
        this.LOG.debug().$("unlocked [table=`").$(tableToken).I$();
    }

    private void checkClosed() {
        if (this.isClosed()) {
            this.LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    private void closeTenant(long thread, Entry<T> entry, int index, short ev, int reason) {
        PoolTenant tenant = (PoolTenant)entry.getTenant(index);
        if (tenant != null) {
            tenant.goodbye();
            tenant.close();
            this.LOG.info().$("closed [table=").$(tenant.getTableToken()).$(", at=").$(entry.index).$(':').$(index).$(", reason=").$(PoolConstants.closeReasonText(reason)).I$();
            this.notifyListener(thread, tenant.getTableToken(), ev, entry.index, index);
            entry.assignTenant(index, null);
        }
    }

    private T get0(TableToken tableToken, @Nullable T copyOfTenant) {
        Entry e = this.getEntry(tableToken);
        long lockOwner = e.lockOwner;
        long thread = Thread.currentThread().getId();
        if (lockOwner != -1L) {
            this.LOG.info().$("table is locked [table=").$(tableToken).$(", owner=").$(lockOwner).I$();
            throw EntryLockedException.instance(NO_LOCK_REASON);
        }
        do {
            for (int i = 0; i < 32; ++i) {
                if (!Unsafe.cas(e.allocations, i, -1L, thread)) continue;
                Unsafe.arrayPutOrdered(e.releaseOrAcquireTimes, i, this.clock.getTicks());
                PoolTenant tenant = (PoolTenant)e.getTenant(i);
                ResourcePoolSupervisor supervisor = this.threadLocalPoolSupervisor.get();
                if (tenant == null) {
                    try {
                        this.LOG.debug().$("open [table=").$(tableToken).$(", at=").$(e.index).$(':').$(i).I$();
                        tenant = copyOfTenant != null ? this.newCopyOfTenant(copyOfTenant, e, i, supervisor) : this.newTenant(tableToken, e, i, supervisor);
                    }
                    catch (CairoException ex) {
                        Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                        throw ex;
                    }
                    e.assignTenant(i, tenant);
                    this.notifyListener(thread, tableToken, (short)10, e.index, i);
                } else {
                    try {
                        if (copyOfTenant != null) {
                            tenant.refreshAt(supervisor, copyOfTenant);
                        } else {
                            tenant.refresh(supervisor);
                        }
                    }
                    catch (Throwable th) {
                        tenant.goodbye();
                        tenant.close();
                        e.assignTenant(i, null);
                        Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                        throw th;
                    }
                    this.notifyListener(thread, tableToken, (short)11, e.index, i);
                }
                if (this.isClosed()) {
                    e.assignTenant(i, null);
                    tenant.goodbye();
                    this.LOG.info().$("born free [table=").$(tableToken).I$();
                    tenant.updateTableToken(tableToken);
                    if (supervisor != null) {
                        supervisor.onResourceBorrowed(tenant);
                    }
                    return (T)tenant;
                }
                this.LOG.debug().$("assigned [table=").$(tableToken).$(", at=").$(e.index).$(':').$(i).$(", thread=").$(thread).I$();
                tenant.updateTableToken(tableToken);
                if (supervisor != null) {
                    supervisor.onResourceBorrowed(tenant);
                }
                return (T)tenant;
            }
            this.LOG.debug().$("Thread ").$(thread).$(" is moving to entry ").$(e.index + 1).$();
            if (Unsafe.getUnsafe().compareAndSwapInt(e, NEXT_STATUS, 0, 1)) {
                this.LOG.debug().$("Thread ").$(thread).$(" allocated entry ").$(e.index + 1).$();
                e.next = new Entry(e.index + 1, this.clock.getTicks());
                continue;
            }
            while (e.next == null && e.nextStatus == 1) {
                Os.pause();
            }
        } while ((e = e.next) != null && e.index < this.maxSegments);
        this.notifyListener(thread, tableToken, (short)25, -1, -1);
        this.LOG.info().$("could not get, busy [table=").$(tableToken).$(", thread=").$(thread).$(", retries=").$(this.maxSegments).I$();
        throw EntryUnavailableException.instance(NO_LOCK_REASON);
    }

    private Entry<T> getEntry(TableToken token) {
        this.checkClosed();
        Entry<T> e = this.entries.get(token.getDirName());
        if (e == null) {
            e = new Entry(0, this.clock.getTicks());
            Entry<T> other = this.entries.putIfAbsent(token.getDirName(), e);
            if (other != null) {
                e = other;
            }
        }
        return e;
    }

    private void notifyListener(long thread, TableToken token, short event, int segment, int position) {
        PoolListener listener = this.getPoolListener();
        if (listener != null) {
            listener.onEvent(this.getListenerSrc(), thread, token, event, (short)segment, (short)position);
        }
    }

    @Override
    protected void closePool() {
        super.closePool();
        this.LOG.info().$("closed").$();
    }

    protected void expelFromPool(T tenant) {
        Entry<Object> e = tenant.getEntry();
        if (e == null) {
            return;
        }
        TableToken tableToken = tenant.getTableToken();
        long thread = Thread.currentThread().getId();
        int index = tenant.getIndex();
        long owner = Unsafe.arrayGetVolatile(e.allocations, index);
        if (owner != -1L) {
            this.LOG.debug().$("table is expelled [table=").$(tableToken).$(", at=").$(e.index).$(':').$(index).$(", thread=").$(thread).I$();
            this.notifyListener(thread, tableToken, (short)2, e.index, index);
            e.assignTenant(index, null);
            Unsafe.cas(e.allocations, index, owner, -1L);
        }
    }

    protected T getCopyOf(@NotNull T srcTenant) {
        if (!this.isCopyOfSupported()) {
            throw new UnsupportedOperationException("getCopyOf is not supported by this pool");
        }
        return this.get0(srcTenant.getTableToken(), srcTenant);
    }

    protected abstract byte getListenerSrc();

    protected T newCopyOfTenant(T srcTenant, Entry<T> entry, int index, @Nullable ResourcePoolSupervisor<T> supervisor) {
        throw new UnsupportedOperationException();
    }

    protected abstract T newTenant(TableToken var1, Entry<T> var2, int var3, @Nullable ResourcePoolSupervisor<T> var4);

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int casFailures = 0;
        int closeReason = deadline < Long.MAX_VALUE ? 3 : 1;
        TableToken leftBehind = null;
        for (Entry<T> e : this.entries.values()) {
            do {
                for (int i = 0; i < 32; ++i) {
                    PoolTenant r;
                    if (deadline <= Unsafe.arrayGetVolatile(e.releaseOrAcquireTimes, i) || (r = (PoolTenant)e.getTenant(i)) == null) continue;
                    if (Unsafe.cas(e.allocations, i, -1L, thread)) {
                        if (deadline > e.releaseOrAcquireTimes[i]) {
                            removed = true;
                            this.closeTenant(thread, e, i, (short)17, closeReason);
                        }
                        Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                        continue;
                    }
                    ++casFailures;
                    if (deadline != Long.MAX_VALUE) continue;
                    r.goodbye();
                    Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                    this.LOG.info().$("shutting down, table is left behind [table=").$(r.getTableToken()).I$();
                    leftBehind = r.getTableToken();
                }
            } while ((e = e.next) != null);
        }
        if (leftBehind != null) {
            throw CairoException.nonCritical().put("table is left behind on pool shutdown [table=").put(leftBehind).put(']');
        }
        if (closeReason == 3) {
            return removed;
        }
        return casFailures == 0;
    }

    protected boolean returnToPool(T tenant) {
        Entry e = tenant.getEntry();
        if (e == null) {
            return false;
        }
        TableToken tableToken = tenant.getTableToken();
        long thread = Thread.currentThread().getId();
        int index = tenant.getIndex();
        long owner = Unsafe.arrayGetVolatile(e.allocations, index);
        if (owner != -1L) {
            this.LOG.debug().$("table is back [table=").$(tableToken).$(", at=").$(e.index).$(':').$(index).$(", thread=").$(thread).I$();
            this.notifyListener(thread, tableToken, (short)1, e.index, index);
            e.releaseOrAcquireTimes[index] = this.clock.getTicks();
            Unsafe.arrayPutOrdered(e.allocations, index, -1L);
            boolean closed = this.isClosed();
            return !closed || !Unsafe.cas(e.allocations, index, -1L, owner);
        }
        if (this.isClosed()) {
            return false;
        }
        throw CairoException.critical(0).put("double close [table=").put(tableToken).put(", index=").put(index).put(']');
    }

    public static final class Entry<T> {
        private final long[] allocations = new long[32];
        private final int index;
        private final long[] releaseOrAcquireTimes = new long[32];
        private final T[] tenants = new Object[32];
        int nextStatus = 0;
        private volatile long lockOwner = -1L;
        private volatile Entry<T> next;

        public Entry(int index, long currentMicros) {
            this.index = index;
            Arrays.fill(this.allocations, -1L);
            Arrays.fill(this.releaseOrAcquireTimes, currentMicros);
        }

        public void assignTenant(int pos, T tenant) {
            this.tenants[pos] = tenant;
        }

        public int getIndex() {
            return this.index;
        }

        public Entry<T> getNext() {
            return this.next;
        }

        public long getOwnerVolatile(int pos) {
            return Unsafe.arrayGetVolatile(this.allocations, pos);
        }

        public long getReleaseOrAcquireTime(int pos) {
            return this.releaseOrAcquireTimes[pos];
        }

        public T getTenant(int pos) {
            return this.tenants[pos];
        }
    }
}

