/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class AtomicBooleanCircuitBreaker
implements SqlExecutionCircuitBreaker {
    private final int throttle;
    protected volatile AtomicBoolean cancelledFlag;
    private long fd = -1L;
    private int testCount = 0;

    public AtomicBooleanCircuitBreaker() {
        this(0);
        this.cancelledFlag = new AtomicBoolean(false);
    }

    public AtomicBooleanCircuitBreaker(int throttle) {
        this.throttle = throttle;
    }

    @Override
    public void cancel() {
        AtomicBoolean cf = this.cancelledFlag;
        if (cf != null) {
            cf.set(true);
        }
    }

    @Override
    public boolean checkIfTripped(long millis, long fd) {
        return this.isCancelled();
    }

    @Override
    public boolean checkIfTripped() {
        return this.isCancelled();
    }

    public void clear() {
        this.fd = -1L;
        this.testCount = 0;
    }

    @Override
    public AtomicBoolean getCancelledFlag() {
        return this.cancelledFlag;
    }

    @Override
    @Nullable
    public SqlExecutionCircuitBreakerConfiguration getConfiguration() {
        return null;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public int getState() {
        return this.isCancelled() ? 3 : 0;
    }

    @Override
    public int getState(long millis, long fd) {
        return this.getState();
    }

    @Override
    public long getTimeout() {
        throw new UnsupportedOperationException("AtomicBooleanCircuitBreaker does not support timeout");
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public boolean isTimerSet() {
        return true;
    }

    public void reset() {
        if (this.cancelledFlag != null) {
            this.cancelledFlag.set(false);
        }
    }

    @Override
    public void resetTimer() {
    }

    @Override
    public void setCancelledFlag(AtomicBoolean cancelledFlag) {
        this.cancelledFlag = cancelledFlag;
    }

    @Override
    public void setFd(long fd) {
        this.fd = fd;
    }

    @Override
    public void statefulThrowExceptionIfTripped() {
        if (this.testCount < this.throttle) {
            ++this.testCount;
        } else {
            this.statefulThrowExceptionIfTrippedNoThrottle();
        }
    }

    @Override
    public void statefulThrowExceptionIfTrippedNoThrottle() {
        this.testCount = 0;
        if (this.isCancelled()) {
            throw CairoException.queryCancelled(this.fd);
        }
    }

    @Override
    public void unsetTimer() {
    }

    private boolean isCancelled() {
        return this.cancelledFlag == null || this.cancelledFlag.get();
    }
}

