/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.std.Misc;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExecutionCircuitBreakerWrapper
implements SqlExecutionCircuitBreaker,
Closeable {
    private SqlExecutionCircuitBreaker delegate;
    private NetworkSqlExecutionCircuitBreaker networkSqlExecutionCircuitBreaker;

    public SqlExecutionCircuitBreakerWrapper(@NotNull SqlExecutionCircuitBreakerConfiguration configuration) {
        this.networkSqlExecutionCircuitBreaker = new NetworkSqlExecutionCircuitBreaker(configuration, 20);
    }

    @Override
    public void cancel() {
        this.delegate.cancel();
    }

    @Override
    public boolean checkIfTripped(long millis, long fd) {
        return this.delegate.checkIfTripped(millis, fd);
    }

    @Override
    public boolean checkIfTripped() {
        return this.delegate.checkIfTripped();
    }

    @Override
    public void close() {
        this.networkSqlExecutionCircuitBreaker = Misc.free(this.networkSqlExecutionCircuitBreaker);
        this.delegate = null;
    }

    @Override
    public AtomicBoolean getCancelledFlag() {
        return this.delegate.getCancelledFlag();
    }

    @Override
    @Nullable
    public SqlExecutionCircuitBreakerConfiguration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public SqlExecutionCircuitBreaker getDelegate() {
        return this.delegate;
    }

    @Override
    public long getFd() {
        return this.delegate.getFd();
    }

    @Override
    public int getState() {
        return this.delegate.getState();
    }

    @Override
    public int getState(long millis, long fd) {
        return this.delegate.getState(millis, fd);
    }

    @Override
    public long getTimeout() {
        return this.delegate.getTimeout();
    }

    public void init(SqlExecutionCircuitBreakerWrapper wrapper) {
        this.init(wrapper.delegate);
    }

    public void init(SqlExecutionCircuitBreaker executionContextCircuitBreaker) {
        if (executionContextCircuitBreaker.isThreadSafe()) {
            this.delegate = executionContextCircuitBreaker;
        } else {
            this.networkSqlExecutionCircuitBreaker.of(executionContextCircuitBreaker.getFd());
            this.networkSqlExecutionCircuitBreaker.setTimeout(executionContextCircuitBreaker.getTimeout());
            this.networkSqlExecutionCircuitBreaker.resetTimer();
            this.networkSqlExecutionCircuitBreaker.setCancelledFlag(executionContextCircuitBreaker.getCancelledFlag());
            this.delegate = this.networkSqlExecutionCircuitBreaker;
        }
    }

    @Override
    public boolean isThreadSafe() {
        return this.delegate.isThreadSafe();
    }

    @Override
    public boolean isTimerSet() {
        return this.delegate.isTimerSet();
    }

    @Override
    public void resetTimer() {
        this.delegate.resetTimer();
    }

    @Override
    public void setCancelledFlag(AtomicBoolean cancelled) {
        this.delegate.setCancelledFlag(cancelled);
    }

    @Override
    public void setFd(long fd) {
        this.delegate.setFd(fd);
    }

    @Override
    public void statefulThrowExceptionIfTripped() {
        this.delegate.statefulThrowExceptionIfTripped();
    }

    @Override
    public void statefulThrowExceptionIfTrippedNoThrottle() {
        this.delegate.statefulThrowExceptionIfTrippedNoThrottle();
    }

    @Override
    public void unsetTimer() {
        this.delegate.unsetTimer();
    }
}

