/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MemorySerializer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemoryFCRImpl;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.wal.seq.TableMetadataChange;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableTransactionLogFile;
import io.questdb.cairo.wal.seq.TableTransactionLogV1;
import io.questdb.cairo.wal.seq.TableTransactionLogV2;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class TableTransactionLog
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableTransactionLog.class);
    private static final ThreadLocal<AlterOperation> tlAlterOperation = new ThreadLocal();
    private static final ThreadLocal<TableMetadataChangeLogImpl> tlStructChangeCursor = new ThreadLocal();
    private final CairoConfiguration configuration;
    private final FilesFacade ff;
    private final AtomicLong maxMetadataVersion = new AtomicLong();
    private final Utf8StringSink rootPath = new Utf8StringSink();
    private final MemoryCMARW txnMetaMem = Vm.getCMARWInstance();
    private final MemoryCMARW txnMetaMemIndex = Vm.getCMARWInstance();
    private volatile long lastTxn = -1L;
    private TableTransactionLogFile txnLogFile;

    TableTransactionLog(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
    }

    public static long readMaxStructureVersion(FilesFacade ff, Path path) {
        int pathLen = path.size();
        long logFileFd = TableUtils.openRW(ff, path.concat("_txnlog").$(), LOG, 0);
        try {
            int formatVersion = ff.readNonNegativeInt(logFileFd, 0L);
            if (formatVersion < 0) {
                throw CairoException.critical(0).put("invalid transaction log file: ").put(path).put(", cannot read version at offset 0");
            }
            switch (formatVersion) {
                case 0: {
                    long l = TableTransactionLogV1.readMaxStructureVersion(logFileFd, ff);
                    return l;
                }
                case 1: {
                    long l = TableTransactionLogV2.readMaxStructureVersion(path.trimTo(pathLen), logFileFd, ff);
                    return l;
                }
            }
            throw new UnsupportedOperationException("Unsupported transaction log version: " + formatVersion);
        }
        finally {
            path.trimTo(pathLen);
            ff.close(logFileFd);
        }
    }

    @Override
    public void close() {
        this.txnLogFile = Misc.free(this.txnLogFile);
        this.txnMetaMem.close(false);
        this.txnMetaMemIndex.close(false);
        this.rootPath.clear();
    }

    public void fullSync() {
        this.txnMetaMemIndex.sync(false);
        this.txnMetaMem.sync(false);
        this.txnLogFile.fullSync();
    }

    public void open(Path path) {
        if (this.rootPath.size() == 0) {
            assert (this.txnLogFile == null);
            this.rootPath.put(path);
            this.txnLogFile = TableTransactionLog.openTxnFile(path, this.configuration);
            long maxStructureVersion = this.txnLogFile.open(path);
            this.openFiles(path);
            this.maxMetadataVersion.set(maxStructureVersion);
            long structureAppendOffset = maxStructureVersion * 8L;
            long txnMetaMemSize = this.txnMetaMemIndex.getLong(structureAppendOffset);
            this.txnMetaMemIndex.jumpTo(structureAppendOffset + 8L);
            this.txnMetaMem.jumpTo(txnMetaMemSize);
        } else assert (Utf8s.equals((Utf8Sequence)path, this.rootPath));
        this.lastTxn = this.txnLogFile.lastTxn();
    }

    public boolean reload(Path path) {
        this.close();
        this.open(path);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFormatVersion(Path path, FilesFacade ff) {
        int formatVersion;
        int pathLen = path.size();
        long logFileFd = TableUtils.openRW(ff, path.concat("_txnlog").$(), LOG, 0);
        try {
            formatVersion = ff.readNonNegativeInt(logFileFd, 0L);
            if (formatVersion < 0) {
                throw CairoException.critical(0).put("invalid transaction log file: ").put(path).put(", cannot read version at offset 0");
            }
        }
        finally {
            path.trimTo(pathLen);
            ff.close(logFileFd);
        }
        return formatVersion;
    }

    private static long openFileRO(FilesFacade ff, Path path, String fileName) {
        return TableUtils.openRO(ff, path, fileName, LOG);
    }

    private static TableTransactionLogFile openTxnFile(Path path, CairoConfiguration configuration) {
        int formatVersion = TableTransactionLog.getFormatVersion(path, configuration.getFilesFacade());
        switch (formatVersion) {
            case 0: {
                return new TableTransactionLogV1(configuration);
            }
            case 1: {
                return new TableTransactionLogV2(configuration, -1);
            }
        }
        throw new UnsupportedOperationException("Unsupported transaction log version: " + formatVersion);
    }

    private void createTxnLogFileInstance() {
        if (this.txnLogFile == null) {
            this.txnLogFile = this.configuration.getDefaultSeqPartTxnCount() > 0 ? new TableTransactionLogV2(this.configuration, this.configuration.getDefaultSeqPartTxnCount()) : new TableTransactionLogV1(this.configuration);
        } else {
            throw new IllegalStateException("transaction log file already opened");
        }
    }

    @NotNull
    static TableMetadataChangeLog getTableMetadataChangeLog() {
        TableMetadataChangeLogImpl instance = tlStructChangeCursor.get();
        if (instance == null) {
            instance = new TableMetadataChangeLogImpl();
            tlStructChangeCursor.set(instance);
        }
        return instance;
    }

    long addEntry(long structureVersion, int walId, int segmentId, int segmentTxn, long timestamp, long txnMinTimestamp, long txnMaxTimestamp, long txnRowCount) {
        this.lastTxn = this.txnLogFile.addEntry(structureVersion, walId, segmentId, segmentTxn, timestamp, txnMinTimestamp, txnMaxTimestamp, txnRowCount);
        return this.lastTxn;
    }

    void beginMetadataChangeEntry(long newStructureVersion, MemorySerializer serializer, Object instance, long timestamp) {
        if (newStructureVersion != this.txnMetaMemIndex.getAppendOffset() / 8L) {
            if (instance instanceof AlterOperation) {
                throw CairoException.critical(0).put("possible corruption in transaction metadata [table=").put(((AlterOperation)instance).getTableToken()).put(", offset=").put(this.txnMetaMemIndex.getAppendOffset()).put(", newVersion=").put(newStructureVersion).put(']');
            }
            throw CairoException.critical(0).put("possible corruption in transaction metadata [offset=").put(this.txnMetaMemIndex.getAppendOffset()).put(", newVersion=").put(newStructureVersion).put(']');
        }
        this.txnLogFile.beginMetadataChangeEntry(newStructureVersion, serializer, instance, timestamp);
        this.txnMetaMem.putInt(0);
        long varMemBegin = this.txnMetaMem.getAppendOffset();
        serializer.toSink(instance, this.txnMetaMem);
        int len = (int)(this.txnMetaMem.getAppendOffset() - varMemBegin);
        this.txnMetaMem.putInt(varMemBegin - 4L, len);
        this.txnMetaMemIndex.putLong(varMemBegin + (long)len);
    }

    void create(Path path, long tableCreateTimestamp) {
        this.rootPath.put(path);
        this.createTxnLogFileInstance();
        this.txnLogFile.create(path, tableCreateTimestamp);
        this.openFiles(path);
        this.txnMetaMem.jumpTo(0L);
        this.txnMetaMem.sync(false);
        this.txnMetaMemIndex.jumpTo(0L);
        this.txnMetaMemIndex.putLong(0L);
        this.txnMetaMemIndex.sync(false);
    }

    long endMetadataChangeEntry() {
        this.fullSync();
        Unsafe.getUnsafe().storeFence();
        long txn = this.lastTxn = this.txnLogFile.endMetadataChangeEntry();
        this.maxMetadataVersion.incrementAndGet();
        return txn;
    }

    TransactionLogCursor getCursor(long txnLo) {
        return this.txnLogFile.getCursor(txnLo, Path.getThreadLocal(this.rootPath));
    }

    @NotNull
    TableMetadataChangeLog getTableMetadataChangeLog(long structureVersionLo, MemorySerializer serializer) {
        TableMetadataChangeLogImpl cursor = (TableMetadataChangeLogImpl)TableTransactionLog.getTableMetadataChangeLog();
        cursor.of(this.ff, structureVersionLo, serializer, Path.getThreadLocal(this.rootPath), this.maxMetadataVersion.get());
        return cursor;
    }

    boolean isDropped() {
        return this.txnLogFile.isDropped();
    }

    long lastTxn() {
        return this.lastTxn;
    }

    void openFiles(Path path) {
        int pathLength = path.size();
        TableUtils.openSmallFile(this.ff, path, pathLength, this.txnMetaMem, "_txnlog.meta.d", 13);
        TableUtils.openSmallFile(this.ff, path, pathLength, this.txnMetaMemIndex, "_txnlog.meta.i", 13);
    }

    AlterOperation readTableMetadataChangeLog(long structureVersion, MemorySerializer serializer) {
        long txnMetaOffset = this.txnMetaMemIndex.getLong(structureVersion * 8L);
        int recordSize = this.txnMetaMem.getInt(txnMetaOffset);
        if (recordSize < 0 || (long)recordSize > Files.PAGE_SIZE) {
            throw CairoException.critical(0).put("invalid sequencer txn metadata [offset=").put(txnMetaOffset).put(", recordSize=").put(recordSize).put(']');
        }
        txnMetaOffset += 4L;
        AlterOperation alterToDeserializeTo = tlAlterOperation.get();
        if (alterToDeserializeTo == null) {
            alterToDeserializeTo = new AlterOperation();
            tlAlterOperation.set(alterToDeserializeTo);
        }
        serializer.fromSink(alterToDeserializeTo, this.txnMetaMem, txnMetaOffset, txnMetaOffset + (long)recordSize);
        this.txnMetaMem.jumpTo(txnMetaOffset + (long)recordSize);
        return alterToDeserializeTo;
    }

    private static class TableMetadataChangeLogImpl
    implements TableMetadataChangeLog {
        private final AlterOperation alterOp = new AlterOperation();
        private final MemoryFCRImpl txnMetaMem = new MemoryFCRImpl();
        private FilesFacade ff;
        private MemorySerializer serializer;
        private long txnMetaAddress;
        private long txnMetaOffset;
        private long txnMetaOffsetHi;

        private TableMetadataChangeLogImpl() {
        }

        @Override
        public void close() {
            if (this.txnMetaAddress > 0L) {
                this.ff.munmap(this.txnMetaAddress, this.txnMetaOffsetHi, 14);
                this.txnMetaAddress = 0L;
            }
            this.txnMetaOffset = 0L;
            this.txnMetaOffsetHi = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.txnMetaOffset < this.txnMetaOffsetHi;
        }

        @Override
        public TableMetadataChange next() {
            int recordSize = this.txnMetaMem.getInt(this.txnMetaOffset);
            if (recordSize < 0 || (long)recordSize > Files.PAGE_SIZE) {
                throw CairoException.critical(0).put("invalid sequencer txn metadata [offset=").put(this.txnMetaOffset).put(", recordSize=").put(recordSize).put(']');
            }
            this.txnMetaOffset += 4L;
            this.serializer.fromSink(this.alterOp, this.txnMetaMem, this.txnMetaOffset, this.txnMetaOffset + (long)recordSize);
            this.txnMetaOffset += (long)recordSize;
            return this.alterOp;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void of(FilesFacade ff, long structureVersionLo, MemorySerializer serializer, Path path, long maxStructureVersion) {
            this.close();
            this.ff = ff;
            this.serializer = serializer;
            long txnMetaFd = -1L;
            long txnMetaIndexFd = -1L;
            try {
                if (maxStructureVersion > structureVersionLo) {
                    txnMetaFd = TableTransactionLog.openFileRO(ff, path, "_txnlog.meta.d");
                    txnMetaIndexFd = TableTransactionLog.openFileRO(ff, path, "_txnlog.meta.i");
                    this.txnMetaOffset = ff.readNonNegativeLong(txnMetaIndexFd, structureVersionLo * 8L);
                    if (this.txnMetaOffset <= -1L) throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
                    this.txnMetaOffsetHi = ff.readNonNegativeLong(txnMetaIndexFd, maxStructureVersion * 8L);
                    if (this.txnMetaOffsetHi <= this.txnMetaOffset) throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
                    this.txnMetaAddress = ff.mmap(txnMetaFd, this.txnMetaOffsetHi, 0L, 1, 14);
                    if (this.txnMetaAddress < 0L) {
                        this.txnMetaAddress = 0L;
                        this.close();
                        throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
                    }
                    this.txnMetaMem.of(this.txnMetaAddress, this.txnMetaOffsetHi);
                    return;
                }
                this.txnMetaOffsetHi = 0L;
                this.txnMetaOffset = 0L;
                return;
            }
            finally {
                ff.close(txnMetaFd);
                ff.close(txnMetaIndexFd);
            }
        }
    }
}

