/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.ConnectionAware;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import java.io.Closeable;

public class LocalValueMap
implements Closeable,
Mutable {
    private static final int INITIAL_CAPACITY = 32;
    private int size = 0;
    private Entry[] table = new Entry[32];
    private int threshold;

    public LocalValueMap() {
        this.setThreshold(32);
    }

    @Override
    public void clear() {
        for (Entry e : this.table) {
            if (e == null || !(e.value instanceof Mutable)) continue;
            ((Mutable)e.value).clear();
        }
    }

    @Override
    public void close() {
        for (Entry e : this.table) {
            if (e != null) {
                e.value = Misc.freeIfCloseable(e.value);
                e.k = null;
            }
            this.table[i] = null;
        }
    }

    public void disconnect() {
        for (Entry e : this.table) {
            if (e == null || !(e.value instanceof ConnectionAware)) continue;
            ((ConnectionAware)e.value).onDisconnected();
        }
    }

    public <T> T get(LocalValue<T> key) {
        int i = key.hashCode & this.table.length - 1;
        Entry e = this.table[i];
        return (T)(e != null && e.k == key ? e.value : this.get0(key, i, e));
    }

    public <T> void set(LocalValue<T> key, T value) {
        int sz;
        Entry[] tab = this.table;
        int len = tab.length;
        int i = key.hashCode & len - 1;
        Entry e = tab[i];
        while (e != null) {
            LocalValue<?> k = e.k;
            if (k == key) {
                Misc.freeIfCloseable(e.value);
                e.value = value;
                return;
            }
            if (k == null) {
                this.replaceNull(key, value, i);
                return;
            }
            i = LocalValueMap.nextIndex(i, len);
            e = tab[i];
        }
        tab[i] = new Entry(key, value);
        if (!this.removeNullKeys(i, sz = ++this.size) && sz >= this.threshold) {
            this.rehash();
        }
    }

    private static int nextIndex(int i, int mod) {
        return i + 1 < mod ? i + 1 : 0;
    }

    private static int prevIndex(int i, int mod) {
        return i - 1 > -1 ? i - 1 : mod - 1;
    }

    private <T> T get0(LocalValue<T> key, int i, Entry e) {
        Entry[] tab = this.table;
        int len = tab.length;
        while (e != null) {
            LocalValue<?> k = e.k;
            if (k == key) {
                return (T)e.value;
            }
            if (k == null) {
                this.removeNull(i);
            } else {
                i = LocalValueMap.nextIndex(i, len);
            }
            e = tab[i];
        }
        return null;
    }

    private void rehash() {
        this.removeNulls();
        if (this.size >= this.threshold - this.threshold / 4) {
            this.resize();
        }
    }

    private int removeNull(int index) {
        Entry e;
        Entry[] tab = this.table;
        int len = tab.length;
        tab[index].value = Misc.freeIfCloseable(tab[index].value);
        tab[index] = null;
        --this.size;
        int i = LocalValueMap.nextIndex(index, len);
        while ((e = tab[i]) != null) {
            LocalValue<?> k = e.k;
            if (k == null) {
                e.value = Misc.freeIfCloseable(e.value);
                tab[i] = null;
                --this.size;
            } else {
                int h = k.hashCode & len - 1;
                if (h != i) {
                    tab[i] = null;
                    while (tab[h] != null) {
                        h = LocalValueMap.nextIndex(h, len);
                    }
                    tab[h] = e;
                }
            }
            i = LocalValueMap.nextIndex(i, len);
        }
        return i;
    }

    private boolean removeNullKeys(int i, int n) {
        boolean removed = false;
        Entry[] tab = this.table;
        int len = tab.length;
        do {
            Entry e;
            if ((e = tab[i = LocalValueMap.nextIndex(i, len)]) == null || e.k != null) continue;
            n = len;
            removed = true;
            i = this.removeNull(i);
        } while ((n >>>= 1) != 0);
        return removed;
    }

    private void removeNulls() {
        Entry[] tab = this.table;
        int len = tab.length;
        for (int j = 0; j < len; ++j) {
            Entry e = tab[j];
            if (e == null || e.k != null) continue;
            this.removeNull(j);
        }
    }

    private void replaceNull(LocalValue<?> key, Object value, int index) {
        Entry e;
        Entry[] tab = this.table;
        int len = tab.length;
        int slotToExpunge = index;
        int i = LocalValueMap.prevIndex(index, len);
        while ((e = tab[i]) != null) {
            if (e.k == null) {
                slotToExpunge = i;
            }
            i = LocalValueMap.prevIndex(i, len);
        }
        i = LocalValueMap.nextIndex(index, len);
        while ((e = tab[i]) != null) {
            LocalValue<?> k = e.k;
            if (k == key) {
                Misc.freeIfCloseable(e.value);
                e.value = value;
                tab[i] = tab[index];
                tab[index] = e;
                if (slotToExpunge == index) {
                    slotToExpunge = i;
                }
                this.removeNullKeys(this.removeNull(slotToExpunge), len);
                return;
            }
            if (k == null && slotToExpunge == index) {
                slotToExpunge = i;
            }
            i = LocalValueMap.nextIndex(i, len);
        }
        tab[index].value = Misc.freeIfCloseable(tab[index].value);
        tab[index] = new Entry(key, value);
        if (slotToExpunge != index) {
            this.removeNullKeys(this.removeNull(slotToExpunge), len);
        }
    }

    private void resize() {
        Entry[] oldTab = this.table;
        int oldLen = oldTab.length;
        int newLen = oldLen * 2;
        Entry[] newTab = new Entry[newLen];
        int count = 0;
        for (int j = 0; j < oldLen; ++j) {
            Entry e = oldTab[j];
            if (e == null) continue;
            LocalValue<?> k = e.k;
            if (k == null) {
                e.value = Misc.freeIfCloseable(e.value);
                continue;
            }
            int h = k.hashCode & newLen - 1;
            while (newTab[h] != null) {
                h = LocalValueMap.nextIndex(h, newLen);
            }
            newTab[h] = e;
            ++count;
        }
        this.setThreshold(newLen);
        this.size = count;
        this.table = newTab;
    }

    private void setThreshold(int len) {
        this.threshold = len * 2 / 3;
    }

    static class Entry {
        LocalValue<?> k;
        Object value;

        Entry(LocalValue<?> k, Object v) {
            this.value = v;
            this.k = k;
        }
    }
}

