/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.SymbolCache;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.network.IODispatcher;
import io.questdb.network.IORequestProcessor;
import io.questdb.std.Misc;
import io.questdb.std.Pool;
import io.questdb.std.Utf8StringObjHashMap;
import io.questdb.std.WeakClosableObjectPool;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8String;
import org.jetbrains.annotations.NotNull;

class LineTcpNetworkIOJob
implements NetworkIOJob {
    private static final Log LOG = LogFactory.getLog(LineTcpNetworkIOJob.class);
    private final IODispatcher<LineTcpConnectionContext> dispatcher;
    private final long maintenanceInterval;
    private final MillisecondClock millisecondClock;
    private final LineTcpMeasurementScheduler scheduler;
    private final Utf8StringObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8 = new Utf8StringObjHashMap();
    private final WeakClosableObjectPool<SymbolCache> unusedSymbolCaches;
    private final int workerId;
    private LineTcpConnectionContext busyContext = null;
    private final IORequestProcessor<LineTcpConnectionContext> onRequest = this::onRequest;
    private long maintenanceJobDeadline;

    LineTcpNetworkIOJob(LineTcpReceiverConfiguration configuration, LineTcpMeasurementScheduler scheduler, IODispatcher<LineTcpConnectionContext> dispatcher, int workerId) {
        try {
            this.millisecondClock = configuration.getMillisecondClock();
            this.maintenanceInterval = configuration.getMaintenanceInterval();
            this.scheduler = scheduler;
            this.maintenanceJobDeadline = this.millisecondClock.getTicks() + this.maintenanceInterval;
            this.dispatcher = dispatcher;
            this.workerId = workerId;
            this.unusedSymbolCaches = new WeakClosableObjectPool<SymbolCache>(() -> new SymbolCache(configuration), 10, true);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void addTableUpdateDetails(Utf8String tableNameUtf8, TableUpdateDetails tableUpdateDetails) {
        this.tableUpdateDetailsUtf8.put(tableNameUtf8, tableUpdateDetails);
        tableUpdateDetails.addReference(this.workerId);
    }

    @Override
    public void close() {
        if (this.busyContext != null) {
            this.dispatcher.disconnect(this.busyContext, 6);
            this.busyContext = null;
        }
        Misc.free(this.unusedSymbolCaches);
    }

    @Override
    public TableUpdateDetails getLocalTableDetails(DirectUtf8Sequence tableNameUtf8) {
        return this.tableUpdateDetailsUtf8.get(tableNameUtf8);
    }

    @Override
    public Pool<SymbolCache> getSymbolCachePool() {
        return this.unusedSymbolCaches;
    }

    @Override
    public int getWorkerId() {
        return this.workerId;
    }

    @Override
    public void releaseWalTableDetails() {
        this.scheduler.releaseWalTableDetails(this.tableUpdateDetailsUtf8);
    }

    @Override
    public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
        long millis;
        assert (this.workerId == workerId);
        boolean busy = false;
        if (this.busyContext != null) {
            if (this.handleIO(this.busyContext, this.dispatcher)) {
                return true;
            }
            LOG.debug().$("context is no longer waiting on a full queue [fd=").$(this.busyContext.getFd()).$(']').$();
            this.busyContext = null;
            busy = true;
        }
        if (this.dispatcher.processIOQueue(this.onRequest)) {
            busy = true;
        }
        if ((millis = this.millisecondClock.getTicks()) > this.maintenanceJobDeadline && !(busy = this.scheduler.doMaintenance(this.tableUpdateDetailsUtf8, workerId, millis))) {
            this.maintenanceJobDeadline = millis + this.maintenanceInterval;
        }
        return busy;
    }

    private boolean handleIO(LineTcpConnectionContext context, IODispatcher<LineTcpConnectionContext> dispatcher) {
        if (!context.invalid()) {
            switch (context.handleIO(this)) {
                case NEEDS_READ: {
                    dispatcher.registerChannel(context, 1);
                    return false;
                }
                case NEEDS_WRITE: {
                    dispatcher.registerChannel(context, 4);
                    return false;
                }
                case QUEUE_FULL: {
                    return true;
                }
                case NEEDS_DISCONNECT: {
                    dispatcher.disconnect(context, 0);
                    return false;
                }
            }
        }
        return false;
    }

    private boolean onRequest(int operation, LineTcpConnectionContext context, IODispatcher<LineTcpConnectionContext> dispatcher) {
        if (operation == 8) {
            context.doMaintenance(this.millisecondClock.getTicks());
            dispatcher.registerChannel(context, 8);
            return false;
        }
        if (this.handleIO(context, dispatcher)) {
            this.busyContext = context;
            LOG.debug().$("context is waiting on a full queue [fd=").$(context.getFd()).$(']').$();
            return false;
        }
        return true;
    }
}

