/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectUtf8Sequence;

public final class DoubleAdapter
extends AbstractTypeAdapter {
    public static final DoubleAdapter INSTANCE = new DoubleAdapter();

    private DoubleAdapter() {
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        if (text.size() > 2 && text.byteAt(0) == 48 && text.byteAt(1) != 46) {
            return false;
        }
        try {
            Numbers.parseDouble(text.lo(), text.size());
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) throws Exception {
        row.putDouble(column, SqlKeywords.isNullKeyword(value) ? Double.NaN : Numbers.parseDouble(value.lo(), value.size()));
    }
}

