/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Numbers;

public class DoubleConstant
extends DoubleFunction
implements ConstantFunction {
    public static final DoubleConstant NULL = new DoubleConstant(Double.NaN);
    public static final DoubleConstant ONE = new DoubleConstant(1.0);
    private final double value;

    public DoubleConstant(double value) {
        this.value = value;
    }

    public static DoubleConstant newInstance(double value) {
        return Numbers.isFinite(value) ? new DoubleConstant(value) : NULL;
    }

    @Override
    public double getDouble(Record rec) {
        return this.value;
    }

    @Override
    public boolean isNullConstant() {
        return Numbers.isNull(this.value);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.value);
    }
}

