/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;

public class ToTimestampVCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_timestamp(Ss)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        CharSequence pattern = args.getQuick(1).getStrA(null);
        if (pattern == null) {
            throw SqlException.$(argPositions.getQuick(1), "pattern is required");
        }
        if (arg.isConstant()) {
            return this.evaluateConstant(arg, TimestampFormatFactory.INSTANCE.get(pattern), configuration.getDefaultDateLocale());
        }
        return new Func(arg, TimestampFormatFactory.INSTANCE.get(pattern), configuration.getDefaultDateLocale());
    }

    protected TimestampConstant evaluateConstant(Function arg, DateFormat timestampFormat, DateLocale locale) {
        CharSequence value = arg.getStrA(null);
        try {
            if (value != null) {
                return new TimestampConstant(timestampFormat.parse(value, locale));
            }
        }
        catch (NumericException numericException) {
            // empty catch block
        }
        return TimestampConstant.NULL;
    }

    protected static final class Func
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;
        private final DateLocale locale;
        private final DateFormat timestampFormat;

        public Func(Function arg, DateFormat timestampFormat, DateLocale locale) {
            this.arg = arg;
            this.timestampFormat = timestampFormat;
            this.locale = locale;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getTimestamp(Record rec) {
            CharSequence value = this.arg.getStrA(rec);
            try {
                if (value != null) {
                    return this.timestampFormat.parse(value, this.locale);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("to_timestamp(").val(this.arg).val(')');
        }
    }
}

