/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class IPv4PlusIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "+(XI)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new IPv4PlusIntFunction(args.getQuick(0), args.getQuick(1));
    }

    public static final class IPv4PlusIntFunction
    extends IPv4Function
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public IPv4PlusIntFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int getIPv4(Record rec) {
            int l = this.left.getIPv4(rec);
            int r = this.right.getInt(rec);
            long sum = Numbers.ipv4ToLong(l) + (long)r;
            if (sum >> 32 != 0L) {
                return 0;
            }
            return l != 0 && r != Integer.MIN_VALUE ? (int)sum : 0;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left).val('+').val(this.right);
        }
    }
}

