/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UuidFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndUuidCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_uuid4(i)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new RndFunction(args.getQuick(0).getInt(null));
    }

    private static class RndFunction
    extends UuidFunction
    implements Function {
        private final int nanRate;
        private boolean isNull = false;
        private Rnd rnd;

        public RndFunction(int nanRate) {
            this.nanRate = nanRate + 1;
        }

        @Override
        public long getLong128Hi(Record rec) {
            if (this.isNull) {
                this.isNull = false;
                return Long.MIN_VALUE;
            }
            long hi = this.rnd.nextLong();
            hi &= 0xFFFFFFFFFFFF0FFFL;
            return hi |= 0x4000L;
        }

        @Override
        public long getLong128Lo(Record rec) {
            long lo = this.rnd.nextLong();
            if (lo % (long)this.nanRate == 1L) {
                this.isNull = true;
                return Long.MIN_VALUE;
            }
            lo &= 0x3FFFFFFFFFFFFFFFL;
            return lo |= Long.MIN_VALUE;
        }

        @Override
        public String getName() {
            return "rnd_uuid4";
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public boolean shouldMemoize() {
            return true;
        }
    }
}

