/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class SizePrettyFunctionFactory
implements FunctionFactory {
    public static final String SYMBOL = "size_pretty";
    private static final char[] SCALE = new char[]{'B', 'K', 'M', 'G', 'T', 'P', 'E', 'Z'};

    public static void toSizePretty(StringSink sink, long size) {
        sink.clear();
        int z = Numbers.msb(size) / 10;
        long scale = 1L << z * 10;
        float value = (float)size / (float)scale;
        Numbers.append(sink, value, 1);
        sink.put(' ').put(SCALE[z]);
        if (z > 0) {
            sink.put("iB");
        }
    }

    public static String toSizePretty(long size) {
        StringSink sink = Misc.getThreadLocalSink();
        SizePrettyFunctionFactory.toSizePretty(sink, size);
        return sink.toString();
    }

    @Override
    public String getSignature() {
        return "size_pretty(L)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPos, CairoConfiguration config, SqlExecutionContext context) {
        return new SizePretty(args.getQuick(0));
    }

    private static class SizePretty
    extends StrFunction
    implements UnaryFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function size;

        private SizePretty(Function size) {
            this.size = size;
        }

        @Override
        public Function getArg() {
            return this.size;
        }

        @Override
        public String getName() {
            return SizePrettyFunctionFactory.SYMBOL;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.getStr0(this.size.getLong(rec), this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr0(this.size.getLong(rec), this.sinkB);
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Nullable
        private StringSink getStr0(long s, StringSink sink) {
            if (s != Long.MIN_VALUE) {
                SizePrettyFunctionFactory.toSizePretty(sink, s);
                return sink;
            }
            return null;
        }
    }
}

