/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.groupby.MicroTimestampSampler;
import io.questdb.griffin.engine.groupby.MonthTimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.YearTimestampSampler;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import org.jetbrains.annotations.NotNull;

public final class TimestampSamplerFactory {
    public static int findIntervalEndIndex(CharSequence cs, int position, CharSequence kind) throws SqlException {
        int k = -1;
        if (cs == null) {
            throw SqlException.$(position, "missing interval");
        }
        int len = cs.length();
        if (len == 0) {
            throw SqlException.$(position, "expected interval qualifier");
        }
        boolean allZeros = true;
        boolean atLeastOneDigit = false;
        for (int i = 0; i < len; ++i) {
            char c = cs.charAt(i);
            if (c < '0' || c > '9') {
                k = i;
                break;
            }
            atLeastOneDigit = true;
            if (c == '0') continue;
            allZeros = false;
        }
        if (k == 0 && cs.charAt(0) == '-') {
            throw SqlException.$(position, "negative interval is not allowed");
        }
        if (allZeros && atLeastOneDigit) {
            throw SqlException.$(position, "zero is not a valid ").put(kind).put(" value");
        }
        if (k == -1) {
            throw SqlException.$(position + len, "expected interval qualifier");
        }
        if (k + 1 < len) {
            throw SqlException.$(position + k, "expected single letter qualifier");
        }
        return k;
    }

    public static TimestampSampler getInstance(long interval, CharSequence units, int position) throws SqlException {
        if (units.length() == 1) {
            return TimestampSamplerFactory.getInstance(interval, units.charAt(0), position);
        }
        throw SqlException.$(position, "expected one character interval qualifier");
    }

    @NotNull
    public static TimestampSampler getInstance(long interval, char timeUnit, int position) throws SqlException {
        switch (timeUnit) {
            case 'U': {
                return new MicroTimestampSampler(interval);
            }
            case 'T': {
                return new MicroTimestampSampler(1000L * interval);
            }
            case 's': {
                return new MicroTimestampSampler(1000000L * interval);
            }
            case 'm': {
                return new MicroTimestampSampler(60000000L * interval);
            }
            case 'h': {
                return new MicroTimestampSampler(3600000000L * interval);
            }
            case 'd': {
                return new MicroTimestampSampler(86400000000L * interval);
            }
            case 'w': {
                return new MicroTimestampSampler(604800000000L * interval);
            }
            case 'M': {
                return new MonthTimestampSampler((int)interval);
            }
            case 'y': {
                return new YearTimestampSampler((int)interval);
            }
        }
        throw SqlException.$(position, "unsupported interval qualifier");
    }

    public static TimestampSampler getInstance(CharSequence cs, int position) throws SqlException {
        int k = TimestampSamplerFactory.findIntervalEndIndex(cs, position, "sample");
        assert (cs.length() > k);
        long n = TimestampSamplerFactory.parseInterval(cs, k, position, "sample", Integer.MIN_VALUE, '?');
        return TimestampSamplerFactory.getInstance(n, cs.charAt(k), position + k);
    }

    public static long parseInterval(CharSequence cs, int intervalEnd, int position, String kind, int maxValue, char unit) throws SqlException {
        if (intervalEnd == 0) {
            return 1L;
        }
        try {
            int n = Numbers.parseInt(cs, 0, intervalEnd);
            if (n == 0) {
                throw SqlException.$(position, "zero is not a valid ").put(kind).put(" value");
            }
            if (maxValue != Integer.MIN_VALUE && n > maxValue) {
                throw SqlException.$(position, kind).put(" value too high for given units [value=").put(cs).put(", maximum=").put(maxValue).put(unit).put(']');
            }
            return n;
        }
        catch (NumericException e) {
            SqlException ex = SqlException.$(position, "invalid ").put(kind).put(" value [value=").put(cs);
            if (maxValue != Integer.MIN_VALUE) {
                ex.put(", maximum=").put(maxValue).put(unit);
            }
            ex.put(']');
            throw ex;
        }
    }
}

