/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursor;

public class DeferredSymbolIndexFilteredRowCursorFactory
implements FunctionBasedRowCursorFactory {
    private final int columnIndex;
    private final SymbolIndexFilteredRowCursor cursor;
    private final Function symbolFunction;
    private int symbolKey = -2;

    public DeferredSymbolIndexFilteredRowCursorFactory(int columnIndex, Function symbolFunction, Function filter, boolean cachedIndexReaderCursor, int indexDirection) {
        this.columnIndex = columnIndex;
        this.symbolFunction = symbolFunction;
        this.cursor = new SymbolIndexFilteredRowCursor(columnIndex, filter, cachedIndexReaderCursor, indexDirection);
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        if (this.symbolKey == -2) {
            return EmptyRowCursor.INSTANCE;
        }
        return this.cursor.of(pageFrame, pageFrameMemory);
    }

    @Override
    public Function getFunction() {
        return this.symbolFunction;
    }

    @Override
    public void init(PageFrameCursor pageFrameCursor, SqlExecutionContext sqlExecutionContext) throws SqlException {
        this.symbolFunction.init(pageFrameCursor, sqlExecutionContext);
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void prepareCursor(PageFrameCursor pageFrameCursor) {
        this.symbolKey = pageFrameCursor.getSymbolTable(this.columnIndex).keyOf(this.symbolFunction.getStrA(null));
        if (this.symbolKey != -2) {
            this.cursor.of(this.symbolKey);
            this.cursor.prepare(pageFrameCursor);
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type(BitmapIndexReader.nameOf(this.cursor.getIndexDirection())).type(" scan").meta("on").putBaseColumnName(this.columnIndex);
        sink.meta("deferred").val(true);
        sink.attr("symbolFilter").putBaseColumnName(this.columnIndex).val('=').val(this.symbolFunction);
        sink.optAttr((CharSequence)"filter", this.cursor.getFilter());
    }
}

