/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.preferences;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cutlass.json.AbstractJsonParser;
import io.questdb.std.CharSequenceObjHashMap;

public final class PreferencesParser
extends AbstractJsonParser {
    private static final int STATE_ROOT = 1;
    private static final int STATE_START = 0;
    private final CharSequenceObjHashMap<CharSequence> parserMap;
    private CharSequence key;
    private int state = 0;

    public PreferencesParser(CairoConfiguration configuration, CharSequenceObjHashMap<CharSequence> parserMap) {
        super(configuration.getPreferencesStringPoolCapacity());
        this.parserMap = parserMap;
    }

    @Override
    public void clear() {
        super.clear();
        this.parserMap.clear();
        this.state = 0;
    }

    @Override
    public void onEvent(int code, CharSequence tag, int position) {
        switch (code) {
            case 1: {
                if (this.state == 0) {
                    this.state = 1;
                    break;
                }
                throw CairoException.critical(0).put("unexpected input format [code=").put(code).put(", state=").put(this.state).put(']');
            }
            case 2: {
                if (this.state != 1) break;
                this.state = 0;
                break;
            }
            case 5: {
                if (this.state != 1) break;
                this.key = this.copy(tag);
                break;
            }
            case 6: {
                this.parserMap.put(this.key, this.copy(tag));
            }
        }
    }
}

