/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.querybuilder;

import org.influxdb.querybuilder.Column;
import org.influxdb.querybuilder.Function;
import org.influxdb.querybuilder.time.TimeInterval;

public final class FunctionFactory {
    private FunctionFactory() {
    }

    public static Function function(String name, Object ... parameters) {
        FunctionFactory.convertToColumns(parameters);
        return new Function(name, parameters);
    }

    public static Object now() {
        return new Function("now", new Object[0]);
    }

    public static Object count(Object column) {
        return new Function("COUNT", FunctionFactory.convertToColumn(column));
    }

    public static Object max(Object column) {
        return new Function("MAX", FunctionFactory.convertToColumn(column));
    }

    public static Object min(Object column) {
        return new Function("MIN", FunctionFactory.convertToColumn(column));
    }

    public static Object sum(Object column) {
        return new Function("SUM", FunctionFactory.convertToColumn(column));
    }

    public static Object mean(Object column) {
        return new Function("MEAN", FunctionFactory.convertToColumn(column));
    }

    public static Object time(Long timeInterval, String durationLiteral) {
        return new Function("time", new TimeInterval(timeInterval, durationLiteral));
    }

    public static Object time(Long timeInterval, String durationLiteral, Long offsetInterval, String offSetLiteral) {
        return new Function("time", new TimeInterval(timeInterval, durationLiteral), new TimeInterval(offsetInterval, offSetLiteral));
    }

    public static Object column(String name) {
        return new Column(name);
    }

    private static void convertToColumns(Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = FunctionFactory.convertToColumn(arguments[i]);
        }
    }

    private static Object convertToColumn(Object argument) {
        if (argument instanceof String) {
            return FunctionFactory.column((String)argument);
        }
        return argument;
    }
}

