/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
final class WebHookAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(WebHookAlertNotifyHandlerImpl.class);

    WebHookAlertNotifyHandlerImpl() {
    }

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        try {
            String hookUrl = receiver.getHookUrl();
            if (StringUtils.isBlank((CharSequence)hookUrl)) {
                throw new AlertNoticeException("Webhook URL is null or empty");
            }
            HttpHeaders headers = new HttpHeaders();
            if ("Basic".equalsIgnoreCase(receiver.getHookAuthType())) {
                headers.setBasicAuth(receiver.getHookAuthToken());
            } else if ("Bearer".equalsIgnoreCase(receiver.getHookAuthType())) {
                headers.setBearerAuth(receiver.getHookAuthToken());
            }
            headers.setContentType(MediaType.APPLICATION_JSON);
            String webhookJson = this.renderContent(noticeTemplate, alert);
            webhookJson = webhookJson.replace(",\n  }", "\n }");
            HttpEntity alertHttpEntity = new HttpEntity((Object)webhookJson, (MultiValueMap)headers);
            ResponseEntity entity = this.restTemplate.postForEntity(hookUrl, (Object)alertHttpEntity, String.class, new Object[0]);
            if (entity.getStatusCode().value() >= HttpStatus.BAD_REQUEST.value()) {
                log.warn("Send WebHook: {} Failed: {}", (Object)hookUrl, entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send WebHook: {} Success", (Object)hookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[WebHook Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 2;
    }
}

