/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.hertzbeat.alert.calculate.periodic.PeriodicAlertRuleScheduler;
import org.apache.hertzbeat.alert.dao.AlertDefineDao;
import org.apache.hertzbeat.alert.service.AlertDefineImExportService;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.alert.service.DataSourceService;
import org.apache.hertzbeat.base.dao.LabelDao;
import org.apache.hertzbeat.base.service.LabelService;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.util.FileUtil;
import org.apache.hertzbeat.common.util.JexlExpressionRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertDefineServiceImpl
implements AlertDefineService {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineServiceImpl.class);
    @Autowired
    private AlertDefineDao alertDefineDao;
    @Autowired
    private PeriodicAlertRuleScheduler periodicAlertRuleScheduler;
    @Resource
    private LabelService labelService;
    @Resource
    private LabelDao labelDao;
    private final DataSourceService dataSourceService;
    private final Map<String, AlertDefineImExportService> alertDefineImExportServiceMap = new HashMap<String, AlertDefineImExportService>();
    private static final String CONTENT_TYPE = "application/octet-stream;charset=" + StandardCharsets.UTF_8;
    private static final Set<String> SYSTEM_BUILT_IN_LABELS = Set.of("instance", "defineid", "alertname", "instancename", "severity", "alert_mode");

    public AlertDefineServiceImpl(List<AlertDefineImExportService> alertDefineImExportServiceList, DataSourceService dataSourceService) {
        alertDefineImExportServiceList.forEach(it -> this.alertDefineImExportServiceMap.put(it.type(), (AlertDefineImExportService)it));
        this.dataSourceService = dataSourceService;
    }

    @Override
    public void validate(AlertDefine alertDefine, boolean isModify) throws IllegalArgumentException {
        Optional<AlertDefine> optional;
        if (StringUtils.hasText((String)alertDefine.getExpr()) && ("realtime_metric".equals(alertDefine.getType()) || "realtime_log".equals(alertDefine.getType()))) {
            try {
                JexlExpressionRunner.compile((String)alertDefine.getExpr());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("alert expr error: " + e.getMessage());
            }
        }
        if (!(!(optional = this.alertDefineDao.findAlertDefineByName(alertDefine.getName())).isPresent() || isModify && optional.get().getId().equals(alertDefine.getId()))) {
            throw new IllegalArgumentException("alert name already exists");
        }
    }

    @Override
    public void addAlertDefine(AlertDefine alertDefine) throws RuntimeException {
        this.saveNewCustomLabel(alertDefine);
        alertDefine = (AlertDefine)this.alertDefineDao.saveAndFlush(alertDefine);
        this.periodicAlertRuleScheduler.updateSchedule(alertDefine);
        CacheFactory.clearAlertDefineCache();
    }

    @Override
    public void modifyAlertDefine(AlertDefine alertDefine) throws RuntimeException {
        this.saveNewCustomLabel(alertDefine);
        this.alertDefineDao.saveAndFlush(alertDefine);
        this.periodicAlertRuleScheduler.updateSchedule(alertDefine);
        CacheFactory.clearAlertDefineCache();
    }

    private void saveNewCustomLabel(AlertDefine alertDefine) {
        Map<String, String> customLabels;
        List addLabels;
        HashMap labels = alertDefine.getLabels();
        if (labels == null) {
            labels = new HashMap(8);
            alertDefine.setLabels(labels);
        }
        if (!(addLabels = this.labelService.determineNewLabels((customLabels = labels.entrySet().stream().filter(entry -> !this.isSystemBuiltInLabel((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).entrySet())).isEmpty()) {
            this.labelDao.saveAll((Iterable)addLabels);
        }
    }

    private boolean isSystemBuiltInLabel(String labelKey) {
        return SYSTEM_BUILT_IN_LABELS.contains(labelKey);
    }

    @Override
    public void deleteAlertDefine(long alertId) throws RuntimeException {
        this.alertDefineDao.deleteById(alertId);
        this.periodicAlertRuleScheduler.cancelSchedule(alertId);
        CacheFactory.clearAlertDefineCache();
    }

    @Override
    public AlertDefine getAlertDefine(long alertId) throws RuntimeException {
        Optional optional = this.alertDefineDao.findById(alertId);
        return optional.orElse(null);
    }

    @Override
    public void deleteAlertDefines(Set<Long> alertIds) throws RuntimeException {
        this.alertDefineDao.deleteAlertDefinesByIdIn(alertIds);
        for (Long alertId : alertIds) {
            this.periodicAlertRuleScheduler.cancelSchedule(alertId);
        }
        CacheFactory.clearAlertDefineCache();
    }

    @Override
    public Page<AlertDefine> getAlertDefines(List<Long> defineIds, String search, String sort, String order, int pageIndex, int pageSize) {
        ObjectMapper objectMapper = new ObjectMapper();
        List searchList = Collections.emptyList();
        if (StringUtils.hasText((String)search)) {
            try {
                searchList = (List)objectMapper.readValue(URLDecoder.decode(search, StandardCharsets.UTF_8), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to parse search parameter", e);
            }
        }
        List finalSearchList = searchList;
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Object> andList = new ArrayList<Object>();
            if (defineIds != null && !defineIds.isEmpty()) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in((Expression)root.get("id"));
                Iterator iterator = defineIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value((Object)id);
                }
                andList.add(inPredicate);
            }
            if (null != finalSearchList && !finalSearchList.isEmpty()) {
                ArrayList<Predicate> searchPredicates = new ArrayList<Predicate>();
                for (String searchContent : finalSearchList) {
                    searchContent = searchContent.toLowerCase();
                    Predicate predicate = criteriaBuilder.or(new Predicate[]{criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("expr")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("labels")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("annotations")), "%" + searchContent + "%"), criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("template")), "%" + searchContent + "%")});
                    searchPredicates.add(predicate);
                }
                andList.add(criteriaBuilder.or(searchPredicates.toArray(new Predicate[0])));
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        return this.alertDefineDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void export(List<Long> ids, String type, HttpServletResponse res) throws Exception {
        AlertDefineImExportService imExportService = this.alertDefineImExportServiceMap.get(type);
        if (imExportService == null) {
            throw new IllegalArgumentException("not support export type: " + type);
        }
        String fileName = imExportService.getFileName();
        res.setHeader("Content-Type", CONTENT_TYPE);
        res.setContentType(CONTENT_TYPE);
        res.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8));
        res.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        imExportService.exportConfig((OutputStream)res.getOutputStream(), ids);
    }

    @Override
    public void importConfig(MultipartFile file) throws Exception {
        String type = FileUtil.getFileType((MultipartFile)file);
        String fileName = FileUtil.getFileName((MultipartFile)file);
        if (!this.alertDefineImExportServiceMap.containsKey(type)) {
            throw new RuntimeException("file " + fileName + " is not supported.");
        }
        AlertDefineImExportService imExportService = this.alertDefineImExportServiceMap.get(type);
        imExportService.importConfig(file.getInputStream());
    }

    @Override
    public List<AlertDefine> getMetricsRealTimeAlertDefines() {
        List<AlertDefine> alertDefines = CacheFactory.getMetricsAlertDefineCache();
        if (alertDefines == null) {
            alertDefines = this.alertDefineDao.findAlertDefinesByTypeAndEnableTrue("realtime_metric");
            CacheFactory.setMetricsAlertDefineCache(alertDefines);
        }
        return alertDefines;
    }

    @Override
    public List<AlertDefine> getLogRealTimeAlertDefines() {
        List<AlertDefine> alertDefines = CacheFactory.getLogAlertDefineCache();
        if (alertDefines == null) {
            alertDefines = this.alertDefineDao.findAlertDefinesByTypeAndEnableTrue("realtime_log");
            CacheFactory.setLogAlertDefineCache(alertDefines);
        }
        return alertDefines;
    }

    @Override
    public List<Map<String, Object>> getDefinePreview(String datasource, String type, String expr) {
        if (!(StringUtils.hasText((String)expr) && StringUtils.hasText((String)datasource) && StringUtils.hasText((String)type))) {
            return Collections.emptyList();
        }
        switch (type) {
            case "periodic_metric": {
                return this.dataSourceService.calculate(datasource, expr);
            }
            case "periodic_log": {
                return this.dataSourceService.query(datasource, expr);
            }
        }
        log.error("Get define preview unsupported type: {}", (Object)type);
        return Collections.emptyList();
    }

    @Override
    public List<AlertDefine> getAlertDefinesByType(String type) {
        if (!StringUtils.hasText((String)type)) {
            throw new IllegalArgumentException("Alert definition type cannot be null or empty");
        }
        switch (type) {
            case "realtime_metric": 
            case "periodic_metric": 
            case "realtime_log": 
            case "periodic_log": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported alert definition type: " + type);
            }
        }
        return this.alertDefineDao.findAlertDefinesByTypeAndEnableTrue(type);
    }
}

