/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.cache;

import java.time.Duration;
import java.util.List;
import org.apache.hertzbeat.common.cache.CaffeineCacheServiceImpl;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.alerter.AlertSilence;
import org.apache.hertzbeat.common.entity.alerter.NoticeRule;

public final class CacheFactory {
    private static final CommonCacheService<String, Object> COMMON_CACHE = new CaffeineCacheServiceImpl<String, Object>(1, 1000L, Duration.ofDays(1L), false);

    private CacheFactory() {
    }

    public static List<NoticeRule> getNoticeCache() {
        return (List)COMMON_CACHE.get("notice_rule");
    }

    public static void setNoticeCache(List<NoticeRule> noticeRules) {
        COMMON_CACHE.put("notice_rule", noticeRules);
    }

    public static void clearNoticeCache() {
        COMMON_CACHE.remove("notice_rule");
    }

    public static List<AlertSilence> getAlertSilenceCache() {
        return (List)COMMON_CACHE.get("alert_silence");
    }

    public static void setAlertSilenceCache(List<AlertSilence> alertSilences) {
        COMMON_CACHE.put("alert_silence", alertSilences);
    }

    public static void clearAlertSilenceCache() {
        COMMON_CACHE.remove("alert_silence");
    }

    public static List<AlertDefine> getMetricsAlertDefineCache() {
        return (List)COMMON_CACHE.get("metric_alert_define");
    }

    public static void setMetricsAlertDefineCache(List<AlertDefine> alertDefines) {
        COMMON_CACHE.put("metric_alert_define", alertDefines);
    }

    public static void clearMetricsAlertDefineCache() {
        COMMON_CACHE.remove("metric_alert_define");
    }

    public static List<AlertDefine> getLogAlertDefineCache() {
        return (List)COMMON_CACHE.get("log_alert_define");
    }

    public static void setLogAlertDefineCache(List<AlertDefine> alertDefines) {
        COMMON_CACHE.put("log_alert_define", alertDefines);
    }

    public static void clearLogAlertDefineCache() {
        COMMON_CACHE.remove("log_alert_define");
    }

    public static void clearAlertDefineCache() {
        CacheFactory.clearLogAlertDefineCache();
        CacheFactory.clearMetricsAlertDefineCache();
    }
}

