/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.Map;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.queue.impl.InMemoryCommonDataQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Inner Metrics Exporter API")
@RestController
@RequestMapping(path={"/api/metrics"}, produces={"application/json"})
public class MetricsController {
    @Autowired
    private CommonDataQueue commonDataQueue;

    @GetMapping
    @Operation(summary="Get Hertzbeat Metrics Data")
    public ResponseEntity<Message<Map<String, Object>>> getMetricsInfo() {
        HashMap metricsInfo = new HashMap(8);
        CommonDataQueue commonDataQueue = this.commonDataQueue;
        if (commonDataQueue instanceof InMemoryCommonDataQueue) {
            InMemoryCommonDataQueue dataQueue = (InMemoryCommonDataQueue)commonDataQueue;
            Map queueInfo = dataQueue.getQueueSizeMetricsInfo();
            metricsInfo.putAll(queueInfo);
        }
        return ResponseEntity.ok((Object)Message.success(metricsInfo));
    }
}

