/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.geometric;

import com.xugu.cloudjdbc.Error;
import com.xugu.common.ReplaceEnum;
import com.xugu.geometric.DBpoint;
import com.xugu.util.DBobject;
import com.xugu.util.DBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DBpath
extends DBobject
implements Serializable,
Cloneable {
    public boolean open;
    public DBpoint @Nullable [] points;

    public DBpath(DBpoint @Nullable [] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public DBpath() {
        this.type = "path";
    }

    public DBpath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(@Nullable String s) throws SQLException {
        if (s == null) {
            this.points = null;
            return;
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = DBtokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = DBtokenizer.removePara(s);
        } else {
            throw Error.createSQLException("[E50044]Callable: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
        }
        DBtokenizer t = new DBtokenizer(s, ',');
        int npoints = t.getSize();
        DBpoint[] points = new DBpoint[npoints];
        this.points = points;
        for (int p = 0; p < npoints; ++p) {
            points[p] = new DBpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DBpath) {
            DBpath p = (DBpath)obj;
            DBpoint[] points = this.points;
            DBpoint[] pPoints = p.points;
            if (points == null) {
                return pPoints == null;
            }
            if (pPoints == null) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            if (pPoints.length != points.length) {
                return false;
            }
            for (int i = 0; i < points.length; ++i) {
                if (points[i].equals(pPoints[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        DBpoint[] points = this.points;
        if (points == null) {
            return 0;
        }
        int hash = this.open ? 1231 : 1237;
        for (int i = 0; i < points.length && i < 5; ++i) {
            hash = hash * 31 + points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DBpath newDBpath = (DBpath)super.clone();
        if (newDBpath.points != null) {
            DBpoint[] newPoints = (DBpoint[])newDBpath.points.clone();
            newDBpath.points = newPoints;
            for (int i = 0; i < newDBpath.points.length; ++i) {
                newPoints[i] = (DBpoint)newDBpath.points[i].clone();
            }
        }
        return newDBpath;
    }

    @Override
    public @Nullable String getValue() {
        DBpoint[] points = this.points;
        if (points == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(this.open ? "[" : "(");
        for (int p = 0; p < points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(points[p].toString());
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open && this.points != null;
    }

    public boolean isClosed() {
        return !this.open && this.points != null;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

