/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.netty.handler.codec.http2;

import org.apache.kudu.shaded.io.netty.handler.codec.http2.HpackUtil;
import org.apache.kudu.shaded.io.netty.util.internal.ObjectUtil;

class HpackHeaderField {
    static final int HEADER_ENTRY_OVERHEAD = 32;
    final CharSequence name;
    final CharSequence value;

    static long sizeOf(CharSequence name, CharSequence value) {
        return name.length() + value.length() + 32;
    }

    HpackHeaderField(CharSequence name, CharSequence value) {
        this.name = ObjectUtil.checkNotNull(name, "name");
        this.value = ObjectUtil.checkNotNull(value, "value");
    }

    final int size() {
        return this.name.length() + this.value.length() + 32;
    }

    public final boolean equalsForTest(HpackHeaderField other) {
        return HpackUtil.equalsVariableTime(this.name, other.name) && HpackUtil.equalsVariableTime(this.value, other.value);
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

