/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafkaesque.common.message.DescribeGroupsRequestData;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.DescribeGroupsResponse;

public class DescribeGroupsRequest
extends AbstractRequest {
    private final DescribeGroupsRequestData data;
    private final short version;

    private DescribeGroupsRequest(DescribeGroupsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_GROUPS, version);
        this.data = data;
        this.version = version;
    }

    public DescribeGroupsRequest(Struct struct, short version) {
        super(ApiKeys.DESCRIBE_GROUPS, version);
        this.data = new DescribeGroupsRequestData(struct, version);
        this.version = version;
    }

    public DescribeGroupsRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        if (this.version == 0) {
            return DescribeGroupsResponse.fromError(0, Errors.forException(e), this.data.groups());
        }
        return DescribeGroupsResponse.fromError(throttleTimeMs, Errors.forException(e), this.data.groups());
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeGroupsRequest(ApiKeys.DESCRIBE_GROUPS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeGroupsRequest> {
        private final DescribeGroupsRequestData data;

        public Builder(DescribeGroupsRequestData data) {
            super(ApiKeys.DESCRIBE_GROUPS);
            this.data = data;
        }

        @Override
        public DescribeGroupsRequest build(short version) {
            return new DescribeGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

