/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.notification.AtlasNotificationBaseMessage;
import org.apache.atlas.model.notification.MessageVersion;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasNotificationStringMessage
extends AtlasNotificationBaseMessage {
    private String message = null;

    public AtlasNotificationStringMessage() {
        super(MessageVersion.CURRENT_VERSION);
    }

    public AtlasNotificationStringMessage(String message) {
        super(MessageVersion.CURRENT_VERSION);
        this.message = message;
    }

    public AtlasNotificationStringMessage(String message, String msgId, AtlasNotificationBaseMessage.CompressionKind compressionKind) {
        super(MessageVersion.CURRENT_VERSION, msgId, compressionKind);
        this.message = message;
    }

    public AtlasNotificationStringMessage(String message, String msgId, AtlasNotificationBaseMessage.CompressionKind compressionKind, int msgSplitIdx, int msgSplitCount) {
        super(MessageVersion.CURRENT_VERSION, msgId, compressionKind, msgSplitIdx, msgSplitCount);
        this.message = message;
    }

    public AtlasNotificationStringMessage(byte[] encodedBytes, String msgId, AtlasNotificationBaseMessage.CompressionKind compressionKind) {
        super(MessageVersion.CURRENT_VERSION, msgId, compressionKind);
        this.message = AtlasNotificationBaseMessage.getStringUtf8(encodedBytes);
    }

    public AtlasNotificationStringMessage(byte[] encodedBytes, int offset, int length, String msgId, AtlasNotificationBaseMessage.CompressionKind compressionKind, int msgSplitIdx, int msgSplitCount) {
        super(MessageVersion.CURRENT_VERSION, msgId, compressionKind, msgSplitIdx, msgSplitCount);
        this.message = new String(encodedBytes, offset, length);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

