/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.util.Objects;
import org.neo4j.driver.Logger;

public abstract class ReformattedLogger
implements Logger {
    private final Logger delegate;

    protected ReformattedLogger(Logger delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void error(String message, Throwable cause) {
        this.delegate.error(this.reformat(message), cause);
    }

    @Override
    public void info(String message, Object ... params) {
        this.delegate.info(this.reformat(message), params);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.delegate.warn(this.reformat(message), params);
    }

    @Override
    public void warn(String message, Throwable cause) {
        this.delegate.warn(this.reformat(message), cause);
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.reformat(message), params);
        }
    }

    @Override
    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.reformat(message), throwable);
        }
    }

    @Override
    public void trace(String message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(this.reformat(message), params);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    protected abstract String reformat(String var1);
}

