/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilenames;

import java.util.Objects;
import lombok.Generated;
import org.apache.hop.core.util.Utils;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class FileItem {
    private static final String NO = "N";
    @HopMetadataProperty(key="name", injectionKeyDescription="GetFileNames.Injection.Filename.Label")
    private String fileName;
    @HopMetadataProperty(key="filemask", injectionKeyDescription="GetFileNames.Injection.Filemask.Label")
    private String fileMask;
    @HopMetadataProperty(key="exclude_filemask", injectionKeyDescription="GetFileNames.Injection.ExcludeFilemask.Label")
    private String excludeFileMask;
    @HopMetadataProperty(key="file_required", injectionKeyDescription="GetFileNames.Injection.FileRequired.Label")
    private String fileRequired;
    @HopMetadataProperty(key="include_subfolders", injectionKeyDescription="GetFileNames.Injection.IncludeSubDirs.Label")
    private String includeSubFolders;

    public FileItem() {
        this.setDefault();
    }

    public FileItem(String fileName, String fileMask, String excludeFileMask, String fileRequired, String includeSubFolders) {
        this.fileName = fileName;
        this.fileMask = fileMask;
        this.excludeFileMask = excludeFileMask;
        this.fileRequired = Utils.isEmpty((CharSequence)fileRequired) ? NO : fileRequired;
        this.includeSubFolders = Utils.isEmpty((CharSequence)includeSubFolders) ? NO : includeSubFolders;
    }

    protected void setDefault() {
        this.fileRequired = NO;
        this.includeSubFolders = NO;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileItem fileItems = (FileItem)o;
        return this.fileName.equals(fileItems.fileName) && Objects.equals(this.fileMask, fileItems.fileMask) && Objects.equals(this.excludeFileMask, fileItems.excludeFileMask);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileMask, this.excludeFileMask);
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getFileMask() {
        return this.fileMask;
    }

    @Generated
    public String getExcludeFileMask() {
        return this.excludeFileMask;
    }

    @Generated
    public String getFileRequired() {
        return this.fileRequired;
    }

    @Generated
    public String getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    @Generated
    public void setExcludeFileMask(String excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    @Generated
    public void setFileRequired(String fileRequired) {
        this.fileRequired = fileRequired;
    }

    @Generated
    public void setIncludeSubFolders(String includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }
}

