/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget.text;

import java.util.ArrayList;
import java.util.regex.Matcher;
import org.apache.hop.ui.core.widget.text.Format;
import org.apache.hop.ui.core.widget.text.FormatRule;
import org.eclipse.swt.custom.StyleRange;

public class UrlFormatRule
extends FormatRule {
    private static final int LINK_TEXT = 0;
    private static final int LINK_URL = 1;
    private static final String PATTERN = "\\[(.*?)\\]\\((https?://[\\w:.\\?#/=?]+)\\)";

    public UrlFormatRule() {
        super(PATTERN);
    }

    @Override
    public Format execute(String value) {
        Format format = new Format();
        Matcher matcher = this.parse(value);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        while (matcher.find()) {
            StyleRange styleRange = new StyleRange();
            styleRange.start = value.indexOf(matcher.group(0));
            styleRange.length = matcher.group(1).length();
            styleRange.data = matcher.group(2);
            styleRange.underlineStyle = 4;
            styleRange.underline = true;
            styleRanges.add(styleRange);
            value = value.replace(matcher.group(0), matcher.group(1));
        }
        format.setStyleRanges(styleRanges);
        format.setText(value);
        return format;
    }
}

