/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import java.util.function.ToLongFunction;
import org.apache.cassandra.db.guardrails.Threshold;
import org.apache.cassandra.service.ClientState;

public class MinThreshold
extends Threshold {
    public MinThreshold(String name, ToLongFunction<ClientState> warnThreshold, ToLongFunction<ClientState> failThreshold, Threshold.ErrorMessageProvider messageProvider) {
        super(name, warnThreshold, failThreshold, messageProvider);
    }

    @Override
    protected boolean compare(long value, long threshold) {
        return value < threshold;
    }

    @Override
    protected long failValue(ClientState state) {
        long failValue = this.failThreshold.applyAsLong(state);
        return failValue <= 0L ? Long.MIN_VALUE : failValue;
    }

    @Override
    protected long warnValue(ClientState state) {
        long warnValue = this.warnThreshold.applyAsLong(state);
        return warnValue <= 0L ? Long.MIN_VALUE : warnValue;
    }
}

