/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.PeekingIterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements PeekingIterator<T> {
    protected State state = State.NOT_READY;
    protected T next;

    protected AbstractIterator() {
    }

    protected abstract T computeNext();

    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    public final boolean hasNext() {
        Preconditions.checkState((this.state != State.FAILED ? 1 : 0) != 0);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    protected boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        return this.next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final T peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    protected static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

