/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.internal.CommonSettings;
import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.data.ClickHouseFormat;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;

public class QuerySettings {
    public static final int MINIMAL_READ_BUFFER_SIZE = 8192;
    private final CommonSettings settings;

    public QuerySettings(Map<String, Object> settings) {
        this.settings = new CommonSettings();
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            this.settings.setOption(entry.getKey(), entry.getValue());
        }
    }

    public QuerySettings() {
        this.settings = new CommonSettings();
    }

    private QuerySettings(CommonSettings settings) {
        this.settings = settings;
    }

    public QuerySettings setOption(String option, Object value) {
        this.settings.setOption(option, value);
        return this;
    }

    public QuerySettings resetOption(String option) {
        this.settings.resetOption(option);
        return this;
    }

    public Object getOption(String option) {
        return this.settings.getOption(option);
    }

    public Map<String, Object> getAllSettings() {
        return this.settings.getAllSettings();
    }

    public QuerySettings setQueryId(String queryId) {
        this.settings.setQueryId(queryId);
        return this;
    }

    public String getQueryId() {
        return this.settings.getQueryId();
    }

    public QuerySettings setReadBufferSize(Integer size) {
        ValidationUtils.checkNotNull(size, "read_buffer_size");
        ValidationUtils.checkRange(size, 8192, Integer.MAX_VALUE, "read_buffer_size");
        this.settings.setOption("read_buffer_size", size);
        return this;
    }

    public Integer getReadBufferSize() {
        return (Integer)this.settings.getOption("read_buffer_size");
    }

    public QuerySettings setFormat(ClickHouseFormat format) {
        this.settings.setOption("format", (Object)format);
        return this;
    }

    public ClickHouseFormat getFormat() {
        return (ClickHouseFormat)((Object)this.settings.getOption("format"));
    }

    public QuerySettings setMaxExecutionTime(Integer maxExecutionTime) {
        this.settings.setOption("max_execution_time", maxExecutionTime);
        return this;
    }

    public Integer getMaxExecutionTime() {
        return (Integer)this.settings.getOption("max_execution_time");
    }

    public QuerySettings setDatabase(String database) {
        this.settings.setDatabase(database);
        return this;
    }

    public String getDatabase() {
        return this.settings.getDatabase();
    }

    public QuerySettings waitEndOfQuery(Boolean waitEndOfQuery) {
        this.serverSetting("wait_end_of_query", waitEndOfQuery != false ? "1" : "0");
        return this;
    }

    public QuerySettings setUseServerTimeZone(Boolean useServerTimeZone) {
        if (this.settings.hasOption(ClientConfigProperties.USE_TIMEZONE.getKey())) {
            throw new ValidationUtils.SettingsValidationException(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey(), "Cannot set both use_time_zone and use_server_time_zone");
        }
        this.settings.setOption(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey(), useServerTimeZone);
        return this;
    }

    public Boolean getUseServerTimeZone() {
        return (Boolean)this.settings.getOption(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey());
    }

    public QuerySettings setUseTimeZone(String timeZone) {
        if (this.settings.hasOption(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey())) {
            throw new ValidationUtils.SettingsValidationException(ClientConfigProperties.USE_TIMEZONE.getKey(), "Cannot set both use_time_zone and use_server_time_zone");
        }
        this.settings.setOption(ClientConfigProperties.USE_TIMEZONE.getKey(), TimeZone.getTimeZone(timeZone));
        return this;
    }

    public TimeZone getServerTimeZone() {
        return (TimeZone)this.settings.getOption(ClientConfigProperties.SERVER_TIMEZONE.getKey());
    }

    public QuerySettings httpHeader(String key, String value) {
        this.settings.httpHeader(key, value);
        return this;
    }

    public QuerySettings httpHeader(String key, Collection<String> values) {
        this.settings.httpHeader(key, values);
        return this;
    }

    public QuerySettings httpHeaders(Map<String, String> headers) {
        this.settings.httpHeaders(headers);
        return this;
    }

    public QuerySettings serverSetting(String name, String value) {
        this.settings.serverSetting(name, value);
        return this;
    }

    public QuerySettings serverSetting(String name, Collection<String> values) {
        this.settings.serverSetting(name, values);
        return this;
    }

    public QuerySettings setDBRoles(Collection<String> dbRoles) {
        this.settings.setDBRoles(dbRoles);
        return this;
    }

    public Collection<String> getDBRoles() {
        return this.settings.getDBRoles();
    }

    public QuerySettings logComment(String logComment) {
        this.settings.logComment(logComment);
        return this;
    }

    public String getLogComment() {
        return this.settings.getLogComment();
    }

    public void setNetworkTimeout(long timeout, ChronoUnit unit) {
        this.settings.setNetworkTimeout(timeout, unit);
    }

    public Long getNetworkTimeout() {
        return this.settings.getNetworkTimeout();
    }

    public static QuerySettings merge(QuerySettings source, QuerySettings override) {
        CommonSettings mergedSettings = source.settings.copyAndMerge(override.settings);
        return new QuerySettings(mergedSettings);
    }
}

