/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getsubfolders;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFoldersMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GetSubFoldersDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = GetSubFoldersMeta.class;
    public static final String YES = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]);
    public static final String NO = BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
    private Label wlFolderName;
    private Button wbbFolderName;
    private Button wbdFolderName;
    private Button wbeFolderName;
    private Button wbaFolderName;
    private TextVar wFolderName;
    private Label wlFolderNameList;
    private TableView wFolderNameList;
    private final GetSubFoldersMeta input;
    private Button wFolderField;
    private Label wlFilenameField;
    private ComboVar wFolderNameField;
    private Label wlLimit;
    private Text wLimit;
    private Button wInclRowNumber;
    private Label wlInclRowNumberField;
    private TextVar wInclRowNumberField;

    public GetSubFoldersDialog(Shell parent, IVariables variables, GetSubFoldersMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.Preview.Button", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wFolderTab = new CTabItem(wTabFolder, 0);
        wFolderTab.setFont(GuiResource.getInstance().getFontDefault());
        wFolderTab.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FolderTab.TabTitle", (String[])new String[0]));
        Composite wFolderComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFolderComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFolderComp.setLayout((Layout)fileLayout);
        Group wOriginFolders = new Group(wFolderComp, 32);
        PropsUi.setLook((Widget)wOriginFolders);
        wOriginFolders.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.wOriginFiles.Label", (String[])new String[0]));
        FormLayout originFilesgroupLayout = new FormLayout();
        originFilesgroupLayout.marginWidth = 10;
        originFilesgroupLayout.marginHeight = 10;
        wOriginFolders.setLayout((Layout)originFilesgroupLayout);
        Label wlFileField = new Label((Composite)wOriginFolders, 131072);
        wlFileField.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FolderField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileField);
        FormData fdlFileField = new FormData();
        fdlFileField.left = new FormAttachment(0, -margin);
        fdlFileField.top = new FormAttachment(0, margin);
        fdlFileField.right = new FormAttachment(middle, -2 * margin);
        wlFileField.setLayoutData((Object)fdlFileField);
        this.wFolderField = new Button((Composite)wOriginFolders, 32);
        PropsUi.setLook((Widget)this.wFolderField);
        this.wFolderField.setToolTipText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FileField.Tooltip", (String[])new String[0]));
        FormData fdFileField = new FormData();
        fdFileField.left = new FormAttachment(middle, -margin);
        fdFileField.top = new FormAttachment((Control)wlFileField, 0, 0x1000000);
        this.wFolderField.setLayoutData((Object)fdFileField);
        SelectionAdapter lsFileField = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetSubFoldersDialog.this.activateFileField();
                GetSubFoldersDialog.this.input.setChanged();
            }
        };
        this.wFolderField.addSelectionListener((SelectionListener)lsFileField);
        this.wlFilenameField = new Label((Composite)wOriginFolders, 131072);
        this.wlFilenameField.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.wlFilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameField);
        FormData fdlFolderNameField = new FormData();
        fdlFolderNameField.left = new FormAttachment(0, -margin);
        fdlFolderNameField.top = new FormAttachment((Control)this.wFolderField, margin);
        fdlFolderNameField.right = new FormAttachment(middle, -2 * margin);
        this.wlFilenameField.setLayoutData((Object)fdlFolderNameField);
        this.wFolderNameField = new ComboVar(this.variables, (Composite)wOriginFolders, 2056);
        this.wFolderNameField.setEditable(true);
        PropsUi.setLook((Widget)this.wFolderNameField);
        this.wFolderNameField.addModifyListener(lsMod);
        FormData fdFolderNameField = new FormData();
        fdFolderNameField.left = new FormAttachment(middle, -margin);
        fdFolderNameField.top = new FormAttachment((Control)this.wFolderField, margin);
        fdFolderNameField.right = new FormAttachment(100, -margin);
        this.wFolderNameField.setLayoutData((Object)fdFolderNameField);
        this.wFolderNameField.setEnabled(false);
        this.wFolderNameField.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            BaseTransformDialog.getFieldsFromPrevious((IVariables)this.variables, (ComboVar)this.wFolderNameField, (PipelineMeta)this.pipelineMeta, (TransformMeta)this.transformMeta);
            this.shell.setCursor(null);
            busy.dispose();
        });
        FormData fdOriginFolders = new FormData();
        fdOriginFolders.left = new FormAttachment(0, margin);
        fdOriginFolders.top = new FormAttachment((Control)this.wFolderNameList, margin);
        fdOriginFolders.right = new FormAttachment(100, -margin);
        wOriginFolders.setLayoutData((Object)fdOriginFolders);
        this.wlFolderName = new Label(wFolderComp, 131072);
        this.wlFolderName.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFolderName);
        FormData fdlFolderName = new FormData();
        fdlFolderName.left = new FormAttachment(0, 0);
        fdlFolderName.top = new FormAttachment((Control)wOriginFolders, margin);
        fdlFolderName.right = new FormAttachment(middle, -margin);
        this.wlFolderName.setLayoutData((Object)fdlFolderName);
        this.wbbFolderName = new Button(wFolderComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbFolderName);
        this.wbbFolderName.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFolderName.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFolderName = new FormData();
        fdbFolderName.right = new FormAttachment(100, 0);
        fdbFolderName.top = new FormAttachment((Control)wOriginFolders, margin);
        this.wbbFolderName.setLayoutData((Object)fdbFolderName);
        this.wbaFolderName = new Button(wFolderComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbaFolderName);
        this.wbaFolderName.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FolderNameAdd.Button", (String[])new String[0]));
        this.wbaFolderName.setToolTipText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FolderNameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFolderName = new FormData();
        fdbaFolderName.right = new FormAttachment((Control)this.wbbFolderName, -margin);
        fdbaFolderName.top = new FormAttachment((Control)wOriginFolders, margin);
        this.wbaFolderName.setLayoutData((Object)fdbaFolderName);
        this.wFolderName = new TextVar(this.variables, wFolderComp, 18436);
        PropsUi.setLook((Widget)this.wFolderName);
        this.wFolderName.addModifyListener(lsMod);
        FormData fdFolderName = new FormData();
        fdFolderName.left = new FormAttachment(middle, 0);
        fdFolderName.right = new FormAttachment((Control)this.wbaFolderName, -margin);
        fdFolderName.top = new FormAttachment((Control)wOriginFolders, margin);
        this.wFolderName.setLayoutData((Object)fdFolderName);
        this.wlFolderNameList = new Label(wFolderComp, 131072);
        this.wlFolderNameList.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FolderNameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFolderNameList);
        FormData fdlFolderNameList = new FormData();
        fdlFolderNameList.left = new FormAttachment(0, 0);
        fdlFolderNameList.top = new FormAttachment((Control)this.wFolderName, 2 * margin);
        fdlFolderNameList.right = new FormAttachment(middle, -margin);
        this.wlFolderNameList.setLayoutData((Object)fdlFolderNameList);
        this.wbdFolderName = new Button(wFolderComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbdFolderName);
        this.wbdFolderName.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FolderNameDelete.Button", (String[])new String[0]));
        this.wbdFolderName.setToolTipText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FolderNameDelete.Tooltip", (String[])new String[0]));
        FormData fdbdFolderName = new FormData();
        fdbdFolderName.right = new FormAttachment(100, 0);
        fdbdFolderName.top = new FormAttachment((Control)this.wlFolderNameList, 0, 128);
        this.wbdFolderName.setLayoutData((Object)fdbdFolderName);
        this.wbeFolderName = new Button(wFolderComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbeFolderName);
        this.wbeFolderName.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFolderName.setToolTipText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFolderName = new FormData();
        fdbeFolderName.right = new FormAttachment(100, 0);
        fdbeFolderName.left = new FormAttachment((Control)this.wbdFolderName, 0, 16384);
        fdbeFolderName.top = new FormAttachment((Control)this.wbdFolderName, margin);
        this.wbeFolderName.setLayoutData((Object)fdbeFolderName);
        ColumnInfo[] columns = new ColumnInfo[2];
        columns[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.FileDirColumn.Column", (String[])new String[0]), 1, false);
        columns[0].setUsingVariables(true);
        columns[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.Required.Column", (String[])new String[0]), 2, new String[]{YES, NO});
        columns[1].setToolTip(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.Required.Tooltip", (String[])new String[0]));
        this.wFolderNameList = new TableView(this.variables, wFolderComp, 67588, columns, this.input.getFiles().size(), lsMod, this.props);
        PropsUi.setLook((Widget)this.wFolderNameList);
        FormData fdFolderNameList = new FormData();
        fdFolderNameList.left = new FormAttachment(middle, 0);
        fdFolderNameList.right = new FormAttachment((Control)this.wbdFolderName, -margin);
        fdFolderNameList.top = new FormAttachment((Control)this.wlFolderNameList, 0, 128);
        fdFolderNameList.bottom = new FormAttachment(100, -margin);
        this.wFolderNameList.setLayoutData((Object)fdFolderNameList);
        FormData fdFolderComp = new FormData();
        fdFolderComp.left = new FormAttachment(0, 0);
        fdFolderComp.top = new FormAttachment(0, 0);
        fdFolderComp.right = new FormAttachment(100, 0);
        fdFolderComp.bottom = new FormAttachment(100, 0);
        wFolderComp.setLayoutData((Object)fdFolderComp);
        wFolderComp.layout();
        wFolderTab.setControl((Control)wFolderComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem wSettingsTab = new CTabItem(wTabFolder, 0);
        wSettingsTab.setFont(GuiResource.getInstance().getFontDefault());
        wSettingsTab.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.SettingsTab.TabTitle", (String[])new String[0]));
        Composite wSettingsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wSettingsComp);
        FormLayout fileSettingLayout = new FormLayout();
        fileSettingLayout.marginWidth = 3;
        fileSettingLayout.marginHeight = 3;
        wSettingsComp.setLayout((Layout)fileSettingLayout);
        Group wAdditionalGroup = new Group(wSettingsComp, 32);
        PropsUi.setLook((Widget)wAdditionalGroup);
        wAdditionalGroup.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.Group.AdditionalGroup.Label", (String[])new String[0]));
        FormLayout additionalgroupLayout = new FormLayout();
        additionalgroupLayout.marginWidth = 10;
        additionalgroupLayout.marginHeight = 10;
        wAdditionalGroup.setLayout((Layout)additionalgroupLayout);
        Label wlInclRowNumber = new Label((Composite)wAdditionalGroup, 131072);
        wlInclRowNumber.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.InclRowNumber.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRowNumber);
        FormData fdlInclRowNumber = new FormData();
        fdlInclRowNumber.left = new FormAttachment(0, 0);
        fdlInclRowNumber.top = new FormAttachment(0, 2 * margin);
        fdlInclRowNumber.right = new FormAttachment(middle, -margin);
        wlInclRowNumber.setLayoutData((Object)fdlInclRowNumber);
        this.wInclRowNumber = new Button((Composite)wAdditionalGroup, 32);
        PropsUi.setLook((Widget)this.wInclRowNumber);
        this.wInclRowNumber.setToolTipText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.InclRowNumber.Tooltip", (String[])new String[0]));
        FormData fdRowNumber = new FormData();
        fdRowNumber.left = new FormAttachment(middle, 0);
        fdRowNumber.top = new FormAttachment((Control)wlInclRowNumber, 0, 0x1000000);
        this.wInclRowNumber.setLayoutData((Object)fdRowNumber);
        SelectionAdapter linclRowNumber = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetSubFoldersDialog.this.activateIncludeRowNum();
                GetSubFoldersDialog.this.input.setChanged();
            }
        };
        this.wInclRowNumber.addSelectionListener((SelectionListener)linclRowNumber);
        this.wlInclRowNumberField = new Label((Composite)wAdditionalGroup, 131072);
        this.wlInclRowNumberField.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.InclRowNumberField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclRowNumberField);
        FormData fdlInclRowNumberField = new FormData();
        fdlInclRowNumberField.left = new FormAttachment((Control)this.wInclRowNumber, margin);
        fdlInclRowNumberField.top = new FormAttachment(0, 2 * margin);
        this.wlInclRowNumberField.setLayoutData((Object)fdlInclRowNumberField);
        this.wInclRowNumberField = new TextVar(this.variables, (Composite)wAdditionalGroup, 18436);
        PropsUi.setLook((Widget)this.wInclRowNumberField);
        this.wInclRowNumberField.addModifyListener(lsMod);
        FormData fdInclRowNumberField = new FormData();
        fdInclRowNumberField.left = new FormAttachment((Control)this.wlInclRowNumberField, margin);
        fdInclRowNumberField.top = new FormAttachment(0, 2 * margin);
        fdInclRowNumberField.right = new FormAttachment(100, 0);
        this.wInclRowNumberField.setLayoutData((Object)fdInclRowNumberField);
        FormData fdAdditionalGroup = new FormData();
        fdAdditionalGroup.left = new FormAttachment(0, margin);
        fdAdditionalGroup.top = new FormAttachment(0, margin);
        fdAdditionalGroup.right = new FormAttachment(100, -margin);
        wAdditionalGroup.setLayoutData((Object)fdAdditionalGroup);
        this.wlLimit = new Label(wSettingsComp, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)wAdditionalGroup, 2 * margin);
        fdlLimit.right = new FormAttachment(middle, -margin);
        this.wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text(wSettingsComp, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.top = new FormAttachment((Control)wAdditionalGroup, 2 * margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        FormData fdSettingsComp = new FormData();
        fdSettingsComp.left = new FormAttachment(0, 0);
        fdSettingsComp.top = new FormAttachment(0, 0);
        fdSettingsComp.right = new FormAttachment(100, 0);
        fdSettingsComp.bottom = new FormAttachment(100, 0);
        wSettingsComp.setLayoutData((Object)fdSettingsComp);
        wSettingsComp.layout();
        wSettingsTab.setControl((Control)wSettingsComp);
        Listener selA = e -> {
            this.wFolderNameList.add(new String[]{this.wFolderName.getText()});
            this.wFolderName.setText("");
            this.wFolderNameList.removeEmptyRows();
            this.wFolderNameList.setRowNums();
            this.wFolderNameList.optWidth(true);
        };
        this.wbaFolderName.addListener(13, selA);
        this.wFolderName.addListener(13, selA);
        this.wbdFolderName.addListener(13, e -> {
            int[] idx = this.wFolderNameList.getSelectionIndices();
            this.wFolderNameList.remove(idx);
            this.wFolderNameList.removeEmptyRows();
            this.wFolderNameList.setRowNums();
        });
        this.wbeFolderName.addListener(13, e -> {
            int idx = this.wFolderNameList.getSelectionIndex();
            if (idx >= 0) {
                String[] string = this.wFolderNameList.getItem(idx);
                this.wFolderName.setText(string[0]);
                this.wFolderNameList.remove(idx);
            }
            this.wFolderNameList.removeEmptyRows();
            this.wFolderNameList.setRowNums();
        });
        this.wbbFolderName.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wFolderName, (IVariables)this.variables));
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.activateFileField();
        this.activateIncludeRowNum();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activateIncludeRowNum() {
        this.wlInclRowNumberField.setEnabled(this.wInclRowNumber.getSelection());
        this.wInclRowNumberField.setEnabled(this.wInclRowNumber.getSelection());
    }

    private void activateFileField() {
        this.wlFilenameField.setEnabled(this.wFolderField.getSelection());
        this.wFolderNameField.setEnabled(this.wFolderField.getSelection());
        this.wlFolderName.setEnabled(!this.wFolderField.getSelection());
        this.wbbFolderName.setEnabled(!this.wFolderField.getSelection());
        this.wbaFolderName.setEnabled(!this.wFolderField.getSelection());
        this.wFolderName.setEnabled(!this.wFolderField.getSelection());
        this.wlFolderNameList.setEnabled(!this.wFolderField.getSelection());
        this.wbdFolderName.setEnabled(!this.wFolderField.getSelection());
        this.wbeFolderName.setEnabled(!this.wFolderField.getSelection());
        this.wlFolderNameList.setEnabled(!this.wFolderField.getSelection());
        this.wFolderNameList.setEnabled(!this.wFolderField.getSelection());
        this.wPreview.setEnabled(!this.wFolderField.getSelection());
        this.wlLimit.setEnabled(!this.wFolderField.getSelection());
        this.wLimit.setEnabled(!this.wFolderField.getSelection());
    }

    public void getData(GetSubFoldersMeta meta) {
        for (int i = 0; i < meta.getFiles().size(); ++i) {
            GetSubFoldersMeta.GSFile file = meta.getFiles().get(i);
            TableItem item = this.wFolderNameList.table.getItem(i);
            item.setText(1, Const.NVL((String)file.getName(), (String)""));
            item.setText(2, file.isRequired() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFolderNameList.optimizeTableView();
        this.wInclRowNumber.setSelection(meta.isIncludeRowNumber());
        this.wFolderField.setSelection(meta.isFolderNameDynamic());
        if (meta.getRowNumberField() != null) {
            this.wInclRowNumberField.setText(meta.getRowNumberField());
        }
        if (meta.getDynamicFolderNameField() != null) {
            this.wFolderNameField.setText(meta.getDynamicFolderNameField());
        }
        this.wLimit.setText("" + meta.getRowLimit());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(GetSubFoldersMeta in) {
        this.transformName = this.wTransformName.getText();
        in.getFiles().clear();
        for (TableItem item : this.wFolderNameList.getNonEmptyItems()) {
            GetSubFoldersMeta.GSFile file = new GetSubFoldersMeta.GSFile();
            file.setName(item.getText(1));
            file.setRequired(YES.equalsIgnoreCase(item.getText(2)));
            in.getFiles().add(file);
        }
        in.setIncludeRowNumber(this.wInclRowNumber.getSelection());
        in.setDynamicFolderNameField(this.wFolderNameField.getText());
        in.setFolderNameDynamic(this.wFolderField.getSelection());
        in.setRowNumberField(this.wInclRowNumberField.getText());
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
    }

    private void preview() {
        GetSubFoldersMeta oneMeta = new GetSubFoldersMeta();
        this.getInfo(oneMeta);
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            oneMeta.setRowLimit(previewSize);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetSubFoldersDialog.ErrorInPreview.DialogMessage", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                prd.open();
            }
        }
    }
}

