/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.BatchDeleteMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.stub.GrpcMetastorePartitionServiceCallableFactory;
import com.google.cloud.bigquery.storage.v1alpha.stub.MetastorePartitionServiceStub;
import com.google.cloud.bigquery.storage.v1alpha.stub.MetastorePartitionServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcMetastorePartitionServiceStub
extends MetastorePartitionServiceStub {
    private static final MethodDescriptor<BatchCreateMetastorePartitionsRequest, BatchCreateMetastorePartitionsResponse> batchCreateMetastorePartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchCreateMetastorePartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCreateMetastorePartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchCreateMetastorePartitionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchDeleteMetastorePartitionsRequest, Empty> batchDeleteMetastorePartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchDeleteMetastorePartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchDeleteMetastorePartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchUpdateMetastorePartitionsRequest, BatchUpdateMetastorePartitionsResponse> batchUpdateMetastorePartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/BatchUpdateMetastorePartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchUpdateMetastorePartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchUpdateMetastorePartitionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListMetastorePartitionsRequest, ListMetastorePartitionsResponse> listMetastorePartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/ListMetastorePartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListMetastorePartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListMetastorePartitionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamMetastorePartitionsRequest, StreamMetastorePartitionsResponse> streamMetastorePartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.bigquery.storage.v1alpha.MetastorePartitionService/StreamMetastorePartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamMetastorePartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamMetastorePartitionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<BatchCreateMetastorePartitionsRequest, BatchCreateMetastorePartitionsResponse> batchCreateMetastorePartitionsCallable;
    private final UnaryCallable<BatchDeleteMetastorePartitionsRequest, Empty> batchDeleteMetastorePartitionsCallable;
    private final UnaryCallable<BatchUpdateMetastorePartitionsRequest, BatchUpdateMetastorePartitionsResponse> batchUpdateMetastorePartitionsCallable;
    private final UnaryCallable<ListMetastorePartitionsRequest, ListMetastorePartitionsResponse> listMetastorePartitionsCallable;
    private final BidiStreamingCallable<StreamMetastorePartitionsRequest, StreamMetastorePartitionsResponse> streamMetastorePartitionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMetastorePartitionServiceStub create(MetastorePartitionServiceStubSettings settings) throws IOException {
        return new GrpcMetastorePartitionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMetastorePartitionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcMetastorePartitionServiceStub(MetastorePartitionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMetastorePartitionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMetastorePartitionServiceStub(MetastorePartitionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMetastorePartitionServiceStub(MetastorePartitionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMetastorePartitionServiceCallableFactory());
    }

    protected GrpcMetastorePartitionServiceStub(MetastorePartitionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings batchCreateMetastorePartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateMetastorePartitionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings batchDeleteMetastorePartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchDeleteMetastorePartitionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings batchUpdateMetastorePartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchUpdateMetastorePartitionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listMetastorePartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMetastorePartitionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings streamMetastorePartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamMetastorePartitionsMethodDescriptor).build();
        this.batchCreateMetastorePartitionsCallable = callableFactory.createUnaryCallable(batchCreateMetastorePartitionsTransportSettings, settings.batchCreateMetastorePartitionsSettings(), clientContext);
        this.batchDeleteMetastorePartitionsCallable = callableFactory.createUnaryCallable(batchDeleteMetastorePartitionsTransportSettings, settings.batchDeleteMetastorePartitionsSettings(), clientContext);
        this.batchUpdateMetastorePartitionsCallable = callableFactory.createUnaryCallable(batchUpdateMetastorePartitionsTransportSettings, settings.batchUpdateMetastorePartitionsSettings(), clientContext);
        this.listMetastorePartitionsCallable = callableFactory.createUnaryCallable(listMetastorePartitionsTransportSettings, settings.listMetastorePartitionsSettings(), clientContext);
        this.streamMetastorePartitionsCallable = callableFactory.createBidiStreamingCallable(streamMetastorePartitionsTransportSettings, settings.streamMetastorePartitionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<BatchCreateMetastorePartitionsRequest, BatchCreateMetastorePartitionsResponse> batchCreateMetastorePartitionsCallable() {
        return this.batchCreateMetastorePartitionsCallable;
    }

    @Override
    public UnaryCallable<BatchDeleteMetastorePartitionsRequest, Empty> batchDeleteMetastorePartitionsCallable() {
        return this.batchDeleteMetastorePartitionsCallable;
    }

    @Override
    public UnaryCallable<BatchUpdateMetastorePartitionsRequest, BatchUpdateMetastorePartitionsResponse> batchUpdateMetastorePartitionsCallable() {
        return this.batchUpdateMetastorePartitionsCallable;
    }

    @Override
    public UnaryCallable<ListMetastorePartitionsRequest, ListMetastorePartitionsResponse> listMetastorePartitionsCallable() {
        return this.listMetastorePartitionsCallable;
    }

    @Override
    public BidiStreamingCallable<StreamMetastorePartitionsRequest, StreamMetastorePartitionsResponse> streamMetastorePartitionsCallable() {
        return this.streamMetastorePartitionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

