/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;

class SerializableReader
extends Reader
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private char[] charArray_;
    private transient CharArrayReader reader_;

    public SerializableReader(Reader reader, int length) throws IOException, SQLException {
        this.charArray_ = new char[length];
        int numChars = reader.read(this.charArray_);
        if (numChars != length || reader.read() != -1) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Length parameter does not match actual length of buffer.");
            }
            throw new SQLException("Length parameter (" + length + ") does not match actual length of buffer (" + numChars + ").");
        }
        this.reader_ = new CharArrayReader(this.charArray_);
    }

    public SerializableReader(Reader reader) throws IOException, SQLException {
        this.charArray_ = SerializableReader.readerToChars(reader);
        this.reader_ = new CharArrayReader(this.charArray_);
    }

    static final char[] readerToChars(Reader input) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        int actualLength = 0;
        try {
            int length2;
            char[] rawChars = new char[32000];
            while (input.ready() && (length2 = input.read(rawChars)) >= 0) {
                buffer.append(rawChars, 0, length2);
                actualLength += length2;
            }
        }
        catch (IOException e) {
            JDError.throwSQLException("HY105");
        }
        char[] allChars = new char[actualLength];
        buffer.getChars(0, actualLength, allChars, 0);
        return allChars;
    }

    @Override
    public void close() {
        this.reader_.close();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.reader_.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.reader_.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.reader_.read();
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        return this.reader_.read(b, off, len);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.reader_ = new CharArrayReader(this.charArray_);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader_.ready();
    }

    @Override
    public void reset() throws IOException {
        this.reader_.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader_.skip(n);
    }
}

