/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicLineParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestBasicLineParser {
    private BasicLineParser parser;

    TestBasicLineParser() {
    }

    @BeforeEach
    void setup() {
        this.parser = BasicLineParser.INSTANCE;
    }

    @Test
    void testRLParse() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.clear();
        buf.append("GET /stuff HTTP/1.1");
        RequestLine requestline = this.parser.parseRequestLine(buf);
        Assertions.assertEquals((Object)"GET /stuff HTTP/1.1", (Object)requestline.toString());
        Assertions.assertEquals((Object)Method.GET.name(), (Object)requestline.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)requestline.getUri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)requestline.getProtocolVersion());
        buf.clear();
        buf.append("  GET    /stuff   HTTP/1.1   ");
        requestline = this.parser.parseRequestLine(buf);
        Assertions.assertEquals((Object)"GET /stuff HTTP/1.1", (Object)requestline.toString());
        Assertions.assertEquals((Object)Method.GET.name(), (Object)requestline.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)requestline.getUri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)requestline.getProtocolVersion());
        buf.clear();
        buf.append("\rGET /stuff HTTP/1.1");
        requestline = this.parser.parseRequestLine(buf);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)requestline.getMethod());
        Assertions.assertEquals((Object)"/stuff", (Object)requestline.getUri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)requestline.getProtocolVersion());
    }

    @Test
    void testRLParseFailure() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.clear();
        buf.append("    ");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseRequestLine(buf));
        buf.clear();
        buf.append("  GET");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseRequestLine(buf));
        buf.clear();
        buf.append("GET /stuff");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseRequestLine(buf));
        buf.clear();
        buf.append("GET/stuff HTTP/1.1");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseRequestLine(buf));
        buf.clear();
        buf.append("GET /stuff HTTP/1.1 Oooooooooooppsie");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseRequestLine(buf));
    }

    @Test
    void testSLParse() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.clear();
        buf.append("HTTP/1.1 200 OK");
        StatusLine statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK", (Object)statusLine.toString());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusLine.getProtocolVersion());
        Assertions.assertEquals((int)200, (int)statusLine.getStatusCode());
        Assertions.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        buf.clear();
        buf.append("HTTP/1.1 404 Not Found");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((int)404, (int)statusLine.getStatusCode());
        Assertions.assertEquals((Object)"Not Found", (Object)statusLine.getReasonPhrase());
        buf.clear();
        buf.append("HTTP/1.1 404 Non Trouve");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((Object)"Non Trouve", (Object)statusLine.getReasonPhrase());
        buf.clear();
        buf.append("HTTP/1.1 404 Not Found\r\n");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((Object)"Not Found", (Object)statusLine.getReasonPhrase());
        buf.clear();
        buf.append("HTTP/1.1 200 ");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((int)200, (int)statusLine.getStatusCode());
        Assertions.assertEquals((Object)"", (Object)statusLine.getReasonPhrase());
        buf.clear();
        buf.append("HTTP/1.1 200");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((int)200, (int)statusLine.getStatusCode());
        Assertions.assertEquals((Object)"", (Object)statusLine.getReasonPhrase());
        buf.clear();
        buf.append("HTTP/1.1     200 OK");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((int)200, (int)statusLine.getStatusCode());
        Assertions.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        buf.clear();
        buf.append("\nHTTP/1.1 200 OK");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((int)200, (int)statusLine.getStatusCode());
        Assertions.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusLine.getProtocolVersion());
        buf.clear();
        buf.append("  HTTP/1.1 200 OK");
        statusLine = this.parser.parseStatusLine(buf);
        Assertions.assertEquals((int)200, (int)statusLine.getStatusCode());
        Assertions.assertEquals((Object)"OK", (Object)statusLine.getReasonPhrase());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusLine.getProtocolVersion());
    }

    @Test
    void testSLParseFailure() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.clear();
        buf.append("xxx 200 OK");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseStatusLine(buf));
        buf.clear();
        buf.append("HTTP/1.1 xxx OK");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseStatusLine(buf));
        buf.clear();
        buf.append("HTTP/1.1    ");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseStatusLine(buf));
        buf.clear();
        buf.append("HTTP/1.1");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseStatusLine(buf));
        buf.clear();
        buf.append("HTTP/1.1 -200 OK");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseStatusLine(buf));
        buf.clear();
        buf.append("HTTP/1.1 0200 OK");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseStatusLine(buf));
        buf.clear();
        buf.append("HTTP/1.1 2000 OK");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseStatusLine(buf));
    }

    @Test
    void testHttpVersionParsing() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("HTTP/1.1");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        ProtocolVersion version = this.parser.parseProtocolVersion(buffer, cursor);
        Assertions.assertEquals((Object)"HTTP", (Object)version.getProtocol(), (String)"HTTP protocol name");
        Assertions.assertEquals((int)1, (int)version.getMajor(), (String)"HTTP major version number");
        Assertions.assertEquals((int)1, (int)version.getMinor(), (String)"HTTP minor version number");
        Assertions.assertEquals((Object)"HTTP/1.1", (Object)version.toString(), (String)"HTTP version number");
        Assertions.assertEquals((int)buffer.length(), (int)cursor.getPos());
        Assertions.assertTrue((boolean)cursor.atEnd());
        buffer.clear();
        buffer.append("HTTP/1.123 123");
        ParserCursor cursor2 = new ParserCursor(0, buffer.length());
        ProtocolVersion version2 = this.parser.parseProtocolVersion(buffer, cursor2);
        Assertions.assertEquals((Object)"HTTP", (Object)version2.getProtocol(), (String)"HTTP protocol name");
        Assertions.assertEquals((int)1, (int)version2.getMajor(), (String)"HTTP major version number");
        Assertions.assertEquals((int)123, (int)version2.getMinor(), (String)"HTTP minor version number");
        Assertions.assertEquals((Object)"HTTP/1.123", (Object)version2.toString(), (String)"HTTP version number");
        Assertions.assertEquals((char)' ', (char)buffer.charAt(cursor2.getPos()));
        Assertions.assertEquals((int)(buffer.length() - 4), (int)cursor2.getPos());
        Assertions.assertFalse((boolean)cursor2.atEnd());
    }

    @Test
    void testInvalidHttpVersionParsing() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.clear();
        buffer.append("    ");
        ParserCursor cursor1 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor1));
        buffer.clear();
        buffer.append("HTT");
        ParserCursor cursor2 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor2));
        buffer.clear();
        buffer.append("crap");
        ParserCursor cursor3 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor3));
        buffer.clear();
        buffer.append("HTTP/crap");
        ParserCursor cursor4 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor4));
        buffer.clear();
        buffer.append("HTTP/1");
        ParserCursor cursor5 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor5));
        buffer.clear();
        buffer.append("HTTP/1.");
        ParserCursor cursor7 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor7));
        buffer.clear();
        buffer.append("HTTP/whatever.whatever whatever");
        ParserCursor cursor8 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor8));
        buffer.clear();
        buffer.append("HTTP/1.whatever whatever");
        ParserCursor cursor9 = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseProtocolVersion(buffer, cursor9));
    }

    @Test
    void testHeaderParse() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.clear();
        buf.append("header: blah");
        Header header = this.parser.parseHeader(buf);
        Assertions.assertEquals((Object)"header", (Object)header.getName());
        Assertions.assertEquals((Object)"blah", (Object)header.getValue());
        buf.clear();
        buf.append("    header:    blah    ");
        header = this.parser.parseHeader(buf);
        Assertions.assertEquals((Object)"header", (Object)header.getName());
        Assertions.assertEquals((Object)"blah", (Object)header.getValue());
    }

    @Test
    void testInvalidHeaderParsing() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.clear();
        buffer.append("");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseHeader(buffer));
        buffer.clear();
        buffer.append("blah");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseHeader(buffer));
        buffer.clear();
        buffer.append(":");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseHeader(buffer));
        buffer.clear();
        buffer.append("   :");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseHeader(buffer));
        buffer.clear();
        buffer.append(": blah");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseHeader(buffer));
        buffer.clear();
        buffer.append(" : blah");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseHeader(buffer));
        buffer.clear();
        buffer.append("header : blah");
        Assertions.assertThrows(ParseException.class, () -> this.parser.parseHeader(buffer));
    }
}

