/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;
import jdk.net.ExtendedSocketOptions;
import jdk.net.Sockets;
import org.apache.hc.client5.http.ConnectExceptionSupport;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.UnsupportedSchemeException;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.io.DetachedSocketFactory;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.socket.UnixDomainSocketFactory;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpClientConnectionOperator
implements HttpClientConnectionOperator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClientConnectionOperator.class);
    private static final boolean SUPPORTS_KEEPALIVE_OPTIONS = Sockets.supportedOptions(Socket.class).containsAll(Arrays.asList(ExtendedSocketOptions.TCP_KEEPIDLE, ExtendedSocketOptions.TCP_KEEPINTERVAL, ExtendedSocketOptions.TCP_KEEPCOUNT));
    static final DetachedSocketFactory PLAIN_SOCKET_FACTORY = socksProxy -> socksProxy == null ? new Socket() : new Socket(socksProxy);
    private final DetachedSocketFactory detachedSocketFactory;
    private final UnixDomainSocketFactory unixDomainSocketFactory = UnixDomainSocketFactory.getSocketFactory();
    private final Lookup<TlsSocketStrategy> tlsSocketStrategyLookup;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    @Deprecated
    static Lookup<TlsSocketStrategy> adapt(Lookup<ConnectionSocketFactory> lookup) {
        return name -> {
            ConnectionSocketFactory sf = (ConnectionSocketFactory)lookup.lookup(name);
            return sf instanceof LayeredConnectionSocketFactory ? (socket, target, port, attachment, context) -> (SSLSocket)((LayeredConnectionSocketFactory)sf).createLayeredSocket(socket, target, port, attachment, context) : null;
        };
    }

    public DefaultHttpClientConnectionOperator(DetachedSocketFactory detachedSocketFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> tlsSocketStrategyLookup) {
        this.detachedSocketFactory = (DetachedSocketFactory)Args.notNull((Object)detachedSocketFactory, (String)"Plain socket factory");
        this.tlsSocketStrategyLookup = (Lookup)Args.notNull(tlsSocketStrategyLookup, (String)"Socket factory registry");
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    @Deprecated
    public DefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, DefaultHttpClientConnectionOperator.adapt(socketFactoryRegistry));
    }

    public DefaultHttpClientConnectionOperator(SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> tlsSocketStrategyLookup) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, tlsSocketStrategyLookup);
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, TimeValue connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        Timeout timeout = connectTimeout != null ? Timeout.of((long)connectTimeout.getDuration(), (TimeUnit)connectTimeout.getTimeUnit()) : null;
        this.connect(conn, host, null, localAddress, timeout, socketConfig, null, context);
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, InetSocketAddress localAddress, Timeout connectTimeout, SocketConfig socketConfig, Object attachment, HttpContext context) throws IOException {
        this.connect(conn, endpointHost, endpointName, null, localAddress, connectTimeout, socketConfig, attachment, context);
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, Path unixDomainSocket, InetSocketAddress localAddress, Timeout connectTimeout, SocketConfig socketConfig, Object attachment, HttpContext context) throws IOException {
        List<InetSocketAddress> remoteAddresses;
        Proxy socksProxy;
        Args.notNull((Object)conn, (String)"Connection");
        Args.notNull((Object)endpointHost, (String)"Host");
        Args.notNull((Object)socketConfig, (String)"Socket config");
        Args.notNull((Object)context, (String)"Context");
        SocketAddress socksProxyAddress = socketConfig.getSocksProxyAddress();
        Proxy proxy = socksProxy = socksProxyAddress != null ? new Proxy(Proxy.Type.SOCKS, socksProxyAddress) : null;
        if (unixDomainSocket != null) {
            this.connectToUnixDomainSocket(conn, endpointHost, endpointName, attachment, unixDomainSocket, connectTimeout, socketConfig, context);
            return;
        }
        if (endpointHost.getAddress() != null) {
            remoteAddresses = Collections.singletonList(new InetSocketAddress(endpointHost.getAddress(), this.schemePortResolver.resolve(endpointHost.getSchemeName(), (NamedEndpoint)endpointHost)));
        } else {
            int port = this.schemePortResolver.resolve(endpointHost.getSchemeName(), (NamedEndpoint)endpointHost);
            remoteAddresses = this.dnsResolver.resolve(endpointHost.getHostName(), port);
        }
        for (int i = 0; i < remoteAddresses.size(); ++i) {
            InetSocketAddress remoteAddress = remoteAddresses.get(i);
            boolean last = i == remoteAddresses.size() - 1;
            this.onBeforeSocketConnect(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connecting {}->{} ({})", new Object[]{endpointHost, localAddress, remoteAddress, connectTimeout});
            }
            Socket socket = this.detachedSocketFactory.create(endpointHost.getSchemeName(), socksProxy);
            try {
                TlsSocketStrategy tlsSocketStrategy;
                if (localAddress != null) {
                    socket.bind(localAddress);
                }
                conn.bind(socket);
                DefaultHttpClientConnectionOperator.configureSocket(socket, socketConfig, true);
                socket.connect(remoteAddress, TimeValue.isPositive((TimeValue)connectTimeout) ? connectTimeout.toMillisecondsIntBound() : 0);
                conn.bind(socket);
                this.onAfterSocketConnect(context, endpointHost);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {} connected {}->{}", new Object[]{ConnPoolSupport.getId(conn), endpointHost, conn.getLocalAddress(), conn.getRemoteAddress()});
                }
                TlsSocketStrategy tlsSocketStrategy2 = tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? (TlsSocketStrategy)this.tlsSocketStrategyLookup.lookup(endpointHost.getSchemeName()) : null;
                if (tlsSocketStrategy != null) {
                    this.upgradeToTls(conn, endpointHost, endpointName, connectTimeout, attachment, context, tlsSocketStrategy, socket);
                }
                return;
            }
            catch (RuntimeException ex) {
                Closer.closeQuietly((Closeable)socket);
                throw ex;
            }
            catch (IOException ex) {
                Closer.closeQuietly((Closeable)socket);
                if (last) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connection to {} failed ({}); terminating operation", new Object[]{endpointHost, remoteAddress, ex.getClass()});
                    }
                    throw ConnectExceptionSupport.enhance(ex, (NamedEndpoint)endpointHost, new InetAddress[0]);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} connection to {} failed ({}); retrying connection to the next address", new Object[]{endpointHost, remoteAddress, ex.getClass()});
                continue;
            }
        }
    }

    private void upgradeToTls(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, Timeout connectTimeout, Object attachment, HttpContext context, TlsSocketStrategy tlsSocketStrategy, Socket socket) throws IOException {
        Timeout handshakeTimeout;
        NamedEndpoint tlsName = endpointName != null ? endpointName : endpointHost;
        this.onBeforeTlsHandshake(context, endpointHost);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} upgrading to TLS", (Object)ConnPoolSupport.getId(conn), (Object)tlsName);
        }
        TlsConfig tlsConfig = attachment instanceof TlsConfig ? (TlsConfig)attachment : TlsConfig.DEFAULT;
        int soTimeout = socket.getSoTimeout();
        Timeout timeout = handshakeTimeout = tlsConfig.getHandshakeTimeout() != null ? tlsConfig.getHandshakeTimeout() : connectTimeout;
        if (handshakeTimeout != null) {
            socket.setSoTimeout(handshakeTimeout.toMillisecondsIntBound());
        }
        SSLSocket sslSocket = tlsSocketStrategy.upgrade(socket, tlsName.getHostName(), tlsName.getPort(), attachment, context);
        conn.bind(sslSocket, socket);
        socket.setSoTimeout(soTimeout);
        this.onAfterTlsHandshake(context, endpointHost);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} upgraded to TLS", (Object)ConnPoolSupport.getId(conn), (Object)tlsName);
        }
    }

    private void connectToUnixDomainSocket(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, Object attachment, Path unixDomainSocket, Timeout connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        this.onBeforeSocketConnect(context, endpointHost);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connecting to {} ({})", new Object[]{endpointHost, unixDomainSocket, connectTimeout});
        }
        Socket newSocket = this.unixDomainSocketFactory.createSocket();
        try {
            TlsSocketStrategy tlsSocketStrategy;
            conn.bind(newSocket);
            Socket socket = this.unixDomainSocketFactory.connectSocket(newSocket, unixDomainSocket, (TimeValue)connectTimeout);
            conn.bind(socket);
            DefaultHttpClientConnectionOperator.configureSocket(socket, socketConfig, false);
            this.onAfterSocketConnect(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {} connected to {}", new Object[]{ConnPoolSupport.getId(conn), endpointHost, unixDomainSocket});
            }
            TlsSocketStrategy tlsSocketStrategy2 = tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? (TlsSocketStrategy)this.tlsSocketStrategyLookup.lookup(endpointHost.getSchemeName()) : null;
            if (tlsSocketStrategy != null) {
                this.upgradeToTls(conn, endpointHost, endpointName, connectTimeout, attachment, context, tlsSocketStrategy, socket);
            }
        }
        catch (RuntimeException ex) {
            Closer.closeQuietly((Closeable)newSocket);
            throw ex;
        }
        catch (IOException ex) {
            Closer.closeQuietly((Closeable)newSocket);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connection to {} failed ({}); terminating operation", new Object[]{endpointHost, unixDomainSocket, ex.getClass()});
            }
            throw ex;
        }
    }

    private static void configureSocket(Socket socket, SocketConfig socketConfig, boolean isTcp) throws IOException {
        int linger;
        Timeout socketTimeout = socketConfig.getSoTimeout();
        if (socketTimeout != null) {
            socket.setSoTimeout(socketTimeout.toMillisecondsIntBound());
        }
        if (socketConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(socketConfig.getRcvBufSize());
        }
        if (socketConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(socketConfig.getSndBufSize());
        }
        if ((linger = socketConfig.getSoLinger().toMillisecondsIntBound()) >= 0) {
            socket.setSoLinger(true, linger);
        }
        if (isTcp) {
            socket.setReuseAddress(socketConfig.isSoReuseAddress());
            socket.setTcpNoDelay(socketConfig.isTcpNoDelay());
            socket.setKeepAlive(socketConfig.isSoKeepAlive());
            if (SUPPORTS_KEEPALIVE_OPTIONS) {
                if (socketConfig.getTcpKeepIdle() > 0) {
                    Sockets.setOption(socket, ExtendedSocketOptions.TCP_KEEPIDLE, Integer.valueOf(socketConfig.getTcpKeepIdle()));
                }
                if (socketConfig.getTcpKeepInterval() > 0) {
                    Sockets.setOption(socket, ExtendedSocketOptions.TCP_KEEPINTERVAL, Integer.valueOf(socketConfig.getTcpKeepInterval()));
                }
                if (socketConfig.getTcpKeepCount() > 0) {
                    Sockets.setOption(socket, ExtendedSocketOptions.TCP_KEEPCOUNT, Integer.valueOf(socketConfig.getTcpKeepCount()));
                }
            }
        }
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost host, HttpContext context) throws IOException {
        this.upgrade(conn, host, null, null, context);
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, Object attachment, HttpContext context) throws IOException {
        TlsSocketStrategy tlsSocketStrategy;
        Socket socket = conn.getSocket();
        if (socket == null) {
            throw new ConnectionClosedException("Connection is closed");
        }
        String newProtocol = URIScheme.HTTP.same(endpointHost.getSchemeName()) ? URIScheme.HTTPS.id : endpointHost.getSchemeName();
        TlsSocketStrategy tlsSocketStrategy2 = tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? (TlsSocketStrategy)this.tlsSocketStrategyLookup.lookup(newProtocol) : null;
        if (tlsSocketStrategy != null) {
            NamedEndpoint tlsName = endpointName != null ? endpointName : endpointHost;
            this.onBeforeTlsHandshake(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgrading to TLS {}:{}", new Object[]{ConnPoolSupport.getId(conn), tlsName.getHostName(), tlsName.getPort()});
            }
            SSLSocket upgradedSocket = tlsSocketStrategy.upgrade(socket, tlsName.getHostName(), tlsName.getPort(), attachment, context);
            conn.bind(upgradedSocket, socket);
            this.onAfterTlsHandshake(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgraded to TLS {}:{}", new Object[]{ConnPoolSupport.getId(conn), tlsName.getHostName(), tlsName.getPort()});
            }
        } else {
            throw new UnsupportedSchemeException(newProtocol + " protocol is not supported");
        }
    }

    protected void onBeforeSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onBeforeTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }
}

