/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.sofa;

import com.alipay.sofa.registry.client.api.ConfigDataObserver;
import com.alipay.sofa.registry.client.api.Configurator;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.api.SubscriberDataObserver;
import com.alipay.sofa.registry.client.api.model.RegistryType;
import com.alipay.sofa.registry.client.api.registration.ConfiguratorRegistration;
import com.alipay.sofa.registry.client.api.registration.PublisherRegistration;
import com.alipay.sofa.registry.client.api.registration.SubscriberRegistration;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.sofa.SofaRegistryClient;
import com.alipay.sofa.rpc.registry.sofa.SofaRegistryHelper;
import com.alipay.sofa.rpc.registry.sofa.SofaRegistrySubscribeCallback;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Extension(value="sofa")
public class SofaRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaRegistry.class);
    protected final Map<String, Subscriber> subscribers = new ConcurrentHashMap<String, Subscriber>();
    protected final Map<String, Configurator> configurators = new ConcurrentHashMap<String, Configurator>();

    protected SofaRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
        this.subscribers.clear();
        this.configurators.clear();
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String groupId;
                String serviceName = SofaRegistryHelper.buildListDataId(config, server.getProtocol());
                String serviceData = SofaRegistryHelper.convertProviderToUrls(config, server);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000003", serviceName));
                }
                groupId = (groupId = config.getParameter("sofa.group")) == null ? "SOFA" : groupId;
                this.doRegister(appName, serviceName, serviceData, groupId);
                if (!LOGGER.isInfoEnabled(appName)) continue;
                LOGGER.infoWithApp(appName, LogCodes.getLog("010000004", serviceName));
            }
        }
    }

    protected void doRegister(String appName, String serviceName, String serviceData, String group) {
        PublisherRegistration publisherRegistration = new PublisherRegistration(serviceName);
        publisherRegistration.setGroup(group);
        SofaRegistryClient.getRegistryClient(appName, this.registryConfig).register(publisherRegistration, new String[]{serviceData});
    }

    @Override
    public void unRegister(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = SofaRegistryHelper.buildListDataId(config, server.getProtocol());
                try {
                    String groupId = config.getParameter("sofa.group");
                    groupId = groupId == null ? "SOFA" : groupId;
                    this.doUnRegister(appName, serviceName, groupId);
                    if (!LOGGER.isInfoEnabled(appName)) continue;
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000002", serviceName, "1"));
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("010000002", serviceName, "0"), e);
                }
            }
        }
    }

    protected void doUnRegister(String appName, String serviceName, String group) {
        SofaRegistryClient.getRegistryClient(appName, this.registryConfig).unregister(serviceName, group, RegistryType.PUBLISHER);
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unRegister(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unregistry", e);
            }
        }
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        ProviderInfoListener providerInfoListener = config.getProviderInfoListener();
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return null;
        }
        if (!config.isSubscribe()) {
            return null;
        }
        String serviceName = SofaRegistryHelper.buildListDataId(config, config.getProtocol());
        Subscriber listSubscriber = this.subscribers.get(serviceName);
        if (listSubscriber != null && providerInfoListener != null) {
            SofaRegistrySubscribeCallback callback = (SofaRegistrySubscribeCallback)listSubscriber.getDataObserver();
            callback.addProviderInfoListener(serviceName, config, providerInfoListener);
            callback.handleDataToListener(serviceName, config, providerInfoListener);
        } else {
            SofaRegistrySubscribeCallback callback = new SofaRegistrySubscribeCallback();
            callback.addProviderInfoListener(serviceName, config, providerInfoListener);
            SubscriberRegistration subscriberRegistration = new SubscriberRegistration(serviceName, (SubscriberDataObserver)callback);
            String groupId = config.getParameter("sofa.group");
            groupId = groupId == null ? "SOFA" : groupId;
            this.addAttributes(subscriberRegistration, groupId);
            ConfiguratorRegistration configRegistration = new ConfiguratorRegistration(serviceName, (ConfigDataObserver)callback);
            this.addAttributes(configRegistration, "SOFA.CONFIG");
            listSubscriber = SofaRegistryClient.getRegistryClient(appName, this.registryConfig).register(subscriberRegistration);
            Configurator attrSubscriber = SofaRegistryClient.getRegistryClient(appName, this.registryConfig).register(configRegistration);
            this.subscribers.put(serviceName, listSubscriber);
            this.configurators.put(serviceName, attrSubscriber);
        }
        return null;
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        String serviceName = SofaRegistryHelper.buildListDataId(config, config.getProtocol());
        String appName = config.getAppName();
        Subscriber subscriber = this.subscribers.get(serviceName);
        if (subscriber != null) {
            SofaRegistrySubscribeCallback callback = (SofaRegistrySubscribeCallback)subscriber.getDataObserver();
            callback.remove(serviceName, config);
            if (callback.getListenerNum() == 0) {
                SofaRegistryClient.getRegistryClient(appName, this.registryConfig).unregister(serviceName, subscriber.getGroup(), RegistryType.SUBSCRIBER);
                this.subscribers.remove(serviceName);
                SofaRegistryClient.getRegistryClient(appName, this.registryConfig).unregister(serviceName, subscriber.getGroup(), RegistryType.CONFIGURATOR);
                this.configurators.remove(serviceName);
            }
        }
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unSubscribe(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unSubscribe", e);
            }
        }
    }

    private void addAttributes(SubscriberRegistration subscriberRegistration, String group) {
        if (StringUtils.isNotEmpty(group)) {
            subscriberRegistration.setGroup(group);
        }
        subscriberRegistration.setScopeEnum(ScopeEnum.global);
    }

    private void addAttributes(ConfiguratorRegistration configuratorRegistration, String group) {
        if (StringUtils.isNotEmpty(group)) {
            configuratorRegistration.setGroup(group);
        }
    }
}

