/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultMaxBytesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class PreciseFrameDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = Log.logger(PreciseFrameDecoder.class);

    public PreciseFrameDecoder() {
        super.setSingleDecode(true);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        DefaultMaxBytesRecvByteBufAllocator recvByteBufAllocator = new DefaultMaxBytesRecvByteBufAllocator(16, 16);
        ctx.channel().config().setRecvByteBufAllocator((RecvByteBufAllocator)recvByteBufAllocator);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ByteBuf decoded = this.decode(ctx, in);
        if (decoded != null) {
            out.add(decoded);
        }
    }

    protected ByteBuf decode(ChannelHandlerContext ctx, ByteBuf in) {
        if (in.readableBytes() < 16) {
            int nextMaxBytesRead = 16 - in.readableBytes();
            TransportUtil.setMaxBytesPerRead(ctx.channel(), nextMaxBytesRead);
            return null;
        }
        TransportUtil.setMaxBytesPerRead(ctx.channel(), 16);
        assert (in.readableBytes() <= 16);
        ByteBuf buf = in.readRetainedSlice(16);
        short magicNumber = buf.readShort();
        if (magicNumber != 18503) {
            LOG.warn("Network stream corrupted: received incorrect magic number: {}, remote address: {}", (Object)magicNumber, (Object)TransportUtil.remoteAddress(ctx.channel()));
            buf.release();
            return null;
        }
        byte version = buf.readByte();
        if (version != 1) {
            LOG.warn("Network stream corrupted: received incorrect protocol version: {}, remote address: {}", (Object)version, (Object)TransportUtil.remoteAddress(ctx.channel()));
            buf.release();
            return null;
        }
        return buf;
    }
}

