/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.sorting;

import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.sort.sorting.SortManager;
import org.apache.hugegraph.config.TypedOption;

public class RecvSortManager
extends SortManager {
    private static final String NAME = "recv_sort";
    private static final String PREFIX = "recv-sort-executor-%s";

    public RecvSortManager(ComputerContext context) {
        super(context);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    protected String threadPrefix() {
        return PREFIX;
    }

    @Override
    protected Integer threadNum(Config config) {
        if (((Boolean)config.get((TypedOption)ComputerOptions.TRANSPORT_RECV_FILE_MODE)).booleanValue()) {
            return 0;
        }
        return Math.min(super.threadNum(config), this.maxSendSortThreads(config));
    }

    private int maxSendSortThreads(Config config) {
        Integer workerCount = (Integer)config.get((TypedOption)ComputerOptions.JOB_WORKERS_COUNT);
        Integer partitions = (Integer)config.get((TypedOption)ComputerOptions.JOB_PARTITIONS_COUNT);
        return partitions / workerCount;
    }
}

