/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.seqfile;

import java.io.File;
import java.io.IOException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.store.file.seqfile.BitsFileWriter;
import org.apache.hugegraph.computer.core.store.file.seqfile.ValueFileOutput;

public class BitsFileWriterImpl
implements BitsFileWriter {
    private static final int BUFFER_BITS = 64;
    private final ValueFileOutput output;
    private boolean finished;
    private long byteBuffer;
    private int cursor;

    public BitsFileWriterImpl(Config config, String dir) throws IOException {
        this(config, new File(dir));
    }

    public BitsFileWriterImpl(Config config, File dir) throws IOException {
        this.output = new ValueFileOutput(config, dir);
        this.finished = false;
        this.byteBuffer = 0L;
        this.cursor = 0;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.byteBuffer |= 1L << this.cursor;
        }
        ++this.cursor;
        if (this.cursor >= 64) {
            this.output.writeLong(this.byteBuffer);
            this.byteBuffer = 0L;
            this.cursor = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.output.flushBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.output.writeLong(this.byteBuffer);
        this.output.close();
    }
}

