/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class CatalogTableDescriptorSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class TableDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogTableDescriptor> {
        TableDescriptorSerializerV2() {
        }

        @Override
        public CatalogTableDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            ArrayList<String> colocationColumns;
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            CatalogTableSchemaVersions schemaVersions = input.readEntry(CatalogTableSchemaVersions.class);
            List<CatalogTableColumnDescriptor> columns = input.readEntryList(CatalogTableColumnDescriptor.class);
            String storageProfile = input.readUTF();
            int schemaId = input.readVarIntAsInt();
            int pkIndexId = input.readVarIntAsInt();
            int zoneId = input.readVarIntAsInt();
            int pkKeysLen = input.readVarIntAsInt();
            int[] pkColumnIndexes = input.readIntArray(pkKeysLen);
            ArrayList<String> primaryKeyColumns = new ArrayList<String>(pkColumnIndexes.length);
            for (int idx : pkColumnIndexes) {
                primaryKeyColumns.add(columns.get(idx).name());
            }
            int colocationColumnsLen = input.readVarIntAsInt();
            if (colocationColumnsLen == -1) {
                colocationColumns = primaryKeyColumns;
            } else {
                int[] colocationColumnIdxs;
                colocationColumns = new ArrayList(colocationColumnsLen);
                for (int idx : colocationColumnIdxs = input.readIntArray(colocationColumnsLen)) {
                    colocationColumns.add(columns.get(idx).name());
                }
            }
            return CatalogTableDescriptor.builder().id(id).schemaId(schemaId).primaryKeyIndexId(pkIndexId).name(name).zoneId(zoneId).columns(columns).primaryKeyColumns(primaryKeyColumns).colocationColumns(colocationColumns).schemaVersions(schemaVersions).storageProfile(storageProfile).timestamp(updateTimestamp).build();
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeEntry(descriptor.schemaVersions());
            output.writeEntryList(descriptor.columns());
            output.writeUTF(descriptor.storageProfile());
            output.writeVarInt(descriptor.schemaId());
            output.writeVarInt(descriptor.primaryKeyIndexId());
            output.writeVarInt(descriptor.zoneId());
            int[] pkIndexes = TableDescriptorSerializerV2.resolvePkColumnIndexes(descriptor);
            output.writeVarInt(pkIndexes.length);
            output.writeIntArray(pkIndexes);
            if (descriptor.colocationColumns() == descriptor.primaryKeyColumns()) {
                output.writeVarInt(-1L);
            } else {
                int[] colocationIndexes = TableDescriptorSerializerV2.resolveColocationColumnIndexes(pkIndexes, descriptor);
                output.writeVarInt(colocationIndexes.length);
                output.writeIntArray(colocationIndexes);
            }
        }

        private static int[] resolveColocationColumnIndexes(int[] pkColumnIndexes, CatalogTableDescriptor descriptor) {
            int[] colocationColumnIndexes = new int[descriptor.colocationColumns().size()];
            block0: for (int idx : pkColumnIndexes) {
                String columnName = descriptor.columns().get(idx).name();
                for (int j = 0; j < descriptor.colocationColumns().size(); ++j) {
                    if (!descriptor.colocationColumns().get(j).equals(columnName)) continue;
                    colocationColumnIndexes[j] = idx;
                    continue block0;
                }
            }
            return colocationColumnIndexes;
        }

        private static int[] resolvePkColumnIndexes(CatalogTableDescriptor descriptor) {
            List<CatalogTableColumnDescriptor> columns = descriptor.columns();
            List<String> pkColumns = descriptor.primaryKeyColumns();
            assert (columns.size() >= pkColumns.size());
            int[] pkColumnIndexes = new int[pkColumns.size()];
            int foundCount = 0;
            block0: for (int i = 0; i < columns.size() && foundCount < pkColumnIndexes.length; ++i) {
                for (int j = 0; j < pkColumns.size(); ++j) {
                    String pkColumn = pkColumns.get(j);
                    if (!pkColumn.equals(columns.get(i).name())) continue;
                    pkColumnIndexes[j] = i;
                    ++foundCount;
                    continue block0;
                }
            }
            assert (foundCount == pkColumnIndexes.length);
            return pkColumnIndexes;
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class TableDescriptorSerializerV1
    implements CatalogObjectSerializer<CatalogTableDescriptor> {
        private final CatalogEntrySerializerProvider serializers;

        public TableDescriptorSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogTableDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            ArrayList<String> colocationColumns;
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            input.readVarInt();
            CatalogObjectSerializer schemaVerSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_SCHEMA_VERSIONS.id());
            CatalogObjectSerializer tableColumnSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            CatalogTableSchemaVersions schemaVersions = (CatalogTableSchemaVersions)schemaVerSerializer.readFrom(input);
            List<CatalogTableColumnDescriptor> columns = CatalogSerializationUtils.readList(tableColumnSerializer, input);
            String storageProfile = input.readUTF();
            int schemaId = input.readVarIntAsInt();
            int pkIndexId = input.readVarIntAsInt();
            int zoneId = input.readVarIntAsInt();
            int pkKeysLen = input.readVarIntAsInt();
            int[] pkColumnIndexes = input.readIntArray(pkKeysLen);
            ArrayList<String> primaryKeyColumns = new ArrayList<String>(pkColumnIndexes.length);
            for (int idx : pkColumnIndexes) {
                primaryKeyColumns.add(((CatalogTableColumnDescriptor)columns.get(idx)).name());
            }
            int colocationColumnsLen = input.readVarIntAsInt();
            if (colocationColumnsLen == -1) {
                colocationColumns = primaryKeyColumns;
            } else {
                int[] colocationColumnIdxs;
                colocationColumns = new ArrayList(colocationColumnsLen);
                for (int idx : colocationColumnIdxs = input.readIntArray(colocationColumnsLen)) {
                    colocationColumns.add(columns.get(idx).name());
                }
            }
            return CatalogTableDescriptor.builder().id(id).schemaId(schemaId).primaryKeyIndexId(pkIndexId).name(name).zoneId(zoneId).columns(columns).primaryKeyColumns(primaryKeyColumns).colocationColumns(colocationColumns).schemaVersions(schemaVersions).storageProfile(storageProfile).timestamp(CatalogManager.INITIAL_TIMESTAMP).build();
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            CatalogTableSchemaVersions schemaVersions = descriptor.schemaVersions();
            CatalogObjectSerializer tableColumnSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            this.serializers.get(1, schemaVersions.typeId()).writeTo(schemaVersions, output);
            CatalogSerializationUtils.writeList(descriptor.columns(), tableColumnSerializer, output);
            output.writeUTF(descriptor.storageProfile());
            output.writeVarInt(descriptor.schemaId());
            output.writeVarInt(descriptor.primaryKeyIndexId());
            output.writeVarInt(descriptor.zoneId());
            int[] pkIndexes = TableDescriptorSerializerV1.resolvePkColumnIndexes(descriptor);
            output.writeVarInt(pkIndexes.length);
            output.writeIntArray(pkIndexes);
            if (descriptor.colocationColumns() == descriptor.primaryKeyColumns()) {
                output.writeVarInt(-1L);
            } else {
                int[] colocationIndexes = TableDescriptorSerializerV1.resolveColocationColumnIndexes(pkIndexes, descriptor);
                output.writeVarInt(colocationIndexes.length);
                output.writeIntArray(colocationIndexes);
            }
        }

        private static int[] resolveColocationColumnIndexes(int[] pkColumnIndexes, CatalogTableDescriptor descriptor) {
            int[] colocationColumnIndexes = new int[descriptor.colocationColumns().size()];
            block0: for (int idx : pkColumnIndexes) {
                String columnName = descriptor.columns().get(idx).name();
                for (int j = 0; j < descriptor.colocationColumns().size(); ++j) {
                    if (!descriptor.colocationColumns().get(j).equals(columnName)) continue;
                    colocationColumnIndexes[j] = idx;
                    continue block0;
                }
            }
            return colocationColumnIndexes;
        }

        private static int[] resolvePkColumnIndexes(CatalogTableDescriptor descriptor) {
            List<CatalogTableColumnDescriptor> columns = descriptor.columns();
            List<String> pkColumns = descriptor.primaryKeyColumns();
            assert (columns.size() >= pkColumns.size());
            int[] pkColumnIndexes = new int[pkColumns.size()];
            int foundCount = 0;
            block0: for (int i = 0; i < columns.size() && foundCount < pkColumnIndexes.length; ++i) {
                for (int j = 0; j < pkColumns.size(); ++j) {
                    String pkColumn = pkColumns.get(j);
                    if (!pkColumn.equals(columns.get(i).name())) continue;
                    pkColumnIndexes[j] = i;
                    ++foundCount;
                    continue block0;
                }
            }
            assert (foundCount == pkColumnIndexes.length);
            return pkColumnIndexes;
        }
    }
}

