/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.scanner;

import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.scanner.ScannerHandler;
import org.apache.ignite.lang.IgniteBiTuple;

class PrintToLogHandler
implements ScannerHandler {
    private final IgniteLogger log;
    private StringBuilder resultString = new StringBuilder();

    public PrintToLogHandler(IgniteLogger log) {
        this.log = log;
    }

    @Override
    public void handle(IgniteBiTuple<WALPointer, WALRecord> record) {
        this.ensureNotFinished();
        this.resultString.append("Next WAL record :: ").append(ScannerHandler.toStringRecord(record.get2())).append(System.lineSeparator());
    }

    @Override
    public void finish() {
        this.ensureNotFinished();
        String msg = this.resultString.toString();
        this.resultString = null;
        if (this.log.isInfoEnabled()) {
            this.log.info(msg);
        }
    }

    private void ensureNotFinished() {
        if (this.resultString == null) {
            throw new IgniteException("This handler has been already finished.");
        }
    }
}

