/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import org.apache.ignite.IgniteSet;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;

public class ClientIgniteSetRequest
extends ClientRequest {
    private final String name;
    private final int cacheId;
    private final boolean collocated;

    public ClientIgniteSetRequest(BinaryRawReader reader) {
        super(reader);
        this.name = reader.readString();
        this.cacheId = reader.readInt();
        this.collocated = reader.readBoolean();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteSet<Object> igniteSet = this.igniteSet(ctx);
        if (igniteSet == null) {
            return this.notFoundResponse();
        }
        return this.process(igniteSet);
    }

    protected ClientResponse process(IgniteSet<Object> set) {
        return new ClientResponse(this.requestId());
    }

    protected String name() {
        return this.name;
    }

    protected <T> IgniteSet<T> igniteSet(ClientConnectionContext ctx) {
        IgniteSet<Object> set = ctx.kernalContext().grid().set(this.name, this.cacheId, this.collocated, true);
        if (set != null) {
            set = set.withKeepBinary();
        }
        return set;
    }

    protected ClientResponse notFoundResponse() {
        return new ClientResponse(this.requestId(), 1011, String.format("IgniteSet with name '%s' does not exist.", this.name));
    }
}

