/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.jsr166.ConcurrentLinkedHashMap;

public final class IgniteUuidCache {
    private static final int MAX = 1024;
    private static final ConcurrentMap<UUID, UUID> cache = new GridBoundedConcurrentLinkedHashMap<UUID, UUID>(1024, 1024, 0.75f, 64, ConcurrentLinkedHashMap.QueuePolicy.PER_SEGMENT_Q);

    public static UUID onIgniteUuidRead(UUID id) {
        UUID old;
        UUID cached = (UUID)cache.get(id);
        if (cached == null && (old = cache.putIfAbsent(id, cached = id)) != null) {
            cached = old;
        }
        return cached;
    }

    private IgniteUuidCache() {
    }
}

