/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.ignite3.internal.systemview.api.ClusterSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViews;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite3.internal.table.distributed.disaster.GlobalPartitionState;
import org.apache.ignite3.internal.table.distributed.disaster.GlobalTablePartitionState;
import org.apache.ignite3.internal.table.distributed.disaster.LocalPartitionState;
import org.apache.ignite3.internal.table.distributed.disaster.LocalTablePartitionState;
import org.apache.ignite3.internal.type.NativeTypes;

class DisasterRecoverySystemViews {
    private static final Comparator<GlobalTablePartitionState> GLOBAL_TABLE_PARTITION_STATE_COMPARATOR = Comparator.comparing(state -> state.tableName).thenComparingInt(state -> state.partitionId);
    private static final Comparator<SystemViewLocalTablePartitionState> SYSTEM_VIEW_LOCAL_PARTITION_STATE_COMPARATOR = Comparator.comparing(state -> state.state.tableName).thenComparingInt(state -> state.state.partitionId).thenComparing(state -> state.nodeName);
    private static final Comparator<GlobalPartitionState> GLOBAL_ZONE_PARTITION_STATE_COMPARATOR = Comparator.comparing(state -> state.zoneName).thenComparingInt(state -> state.partitionId);
    private static final Comparator<SystemViewLocalZonePartitionState> SYSTEM_VIEW_LOCAL_ZONE_PARTITION_STATE_COMPARATOR = Comparator.comparing(state -> state.state.zoneName).thenComparingInt(state -> state.state.partitionId).thenComparing(state -> state.nodeName);

    DisasterRecoverySystemViews() {
    }

    static SystemView<?> createGlobalTablePartitionStatesSystemView(DisasterRecoveryManager manager) {
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("GLOBAL_PARTITION_STATES")).addColumn("ZONE_NAME", NativeTypes.STRING, state -> state.zoneName)).addColumn("TABLE_ID", NativeTypes.INT32, state -> state.tableId)).addColumn("SCHEMA_NAME", NativeTypes.STRING, state -> state.schemaName)).addColumn("TABLE_NAME", NativeTypes.STRING, state -> state.tableName)).addColumn("PARTITION_ID", NativeTypes.INT32, state -> state.partitionId)).addColumn("PARTITION_STATE", NativeTypes.STRING, state -> state.state.name())).addColumn("ZONE_ID", NativeTypes.INT32, state -> state.zoneId)).addColumn("SCHEMA_ID", NativeTypes.INT32, state -> state.schemaId)).addColumn("STATE", NativeTypes.STRING, state -> state.state.name())).dataProvider(DisasterRecoverySystemViews.systemViewPublisher(() -> DisasterRecoverySystemViews.globalTablePartitionStatesAsync(manager)))).build();
    }

    static SystemView<?> createLocalTablePartitionStatesSystemView(DisasterRecoveryManager manager) {
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("LOCAL_PARTITION_STATES")).addColumn("NODE_NAME", NativeTypes.STRING, state -> state.nodeName)).addColumn("ZONE_NAME", NativeTypes.STRING, state -> state.state.zoneName)).addColumn("TABLE_ID", NativeTypes.INT32, state -> state.state.tableId)).addColumn("SCHEMA_NAME", NativeTypes.STRING, state -> state.state.schemaName)).addColumn("TABLE_NAME", NativeTypes.STRING, state -> state.state.tableName)).addColumn("PARTITION_ID", NativeTypes.INT32, state -> state.state.partitionId)).addColumn("PARTITION_STATE", NativeTypes.STRING, state -> state.state.state.name())).addColumn("ESTIMATED_ROWS", NativeTypes.INT64, state -> state.state.estimatedRows)).addColumn("ZONE_ID", NativeTypes.INT32, state -> state.state.zoneId)).addColumn("SCHEMA_ID", NativeTypes.INT32, state -> state.state.schemaId)).addColumn("STATE", NativeTypes.STRING, state -> state.state.state.name())).dataProvider(DisasterRecoverySystemViews.systemViewPublisher(() -> DisasterRecoverySystemViews.localTablePartitionStatesAsync(manager)))).build();
    }

    static SystemView<?> createGlobalZonePartitionStatesSystemView(DisasterRecoveryManager manager) {
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("GLOBAL_ZONE_PARTITION_STATES")).addColumn("ZONE_NAME", NativeTypes.STRING, state -> state.zoneName)).addColumn("PARTITION_ID", NativeTypes.INT32, state -> state.partitionId)).addColumn("PARTITION_STATE", NativeTypes.STRING, state -> state.state.name())).addColumn("ZONE_ID", NativeTypes.INT32, state -> state.zoneId)).dataProvider(DisasterRecoverySystemViews.systemViewPublisher(() -> DisasterRecoverySystemViews.globalZonePartitionStatesAsync(manager)))).build();
    }

    static SystemView<?> createLocalZonePartitionStatesSystemView(DisasterRecoveryManager manager) {
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("LOCAL_ZONE_PARTITION_STATES")).addColumn("NODE_NAME", NativeTypes.STRING, state -> state.nodeName)).addColumn("ZONE_NAME", NativeTypes.STRING, state -> state.state.zoneName)).addColumn("PARTITION_ID", NativeTypes.INT32, state -> state.state.partitionId)).addColumn("PARTITION_STATE", NativeTypes.STRING, state -> state.state.state.name())).addColumn("ESTIMATED_ROWS", NativeTypes.INT64, state -> state.state.estimatedRows)).addColumn("ZONE_ID", NativeTypes.INT32, state -> state.state.zoneId)).dataProvider(DisasterRecoverySystemViews.systemViewPublisher(() -> DisasterRecoverySystemViews.localZonePartitionStatesAsync(manager)))).build();
    }

    private static <T> Flow.Publisher<T> systemViewPublisher(Supplier<CompletableFuture<Iterator<T>>> invokeApi) {
        return subscriber -> {
            CompletableFuture invokeApiFuture = (CompletableFuture)invokeApi.get();
            subscriber.onSubscribe(new SystemViewSubscription(subscriber, invokeApiFuture));
        };
    }

    private static CompletableFuture<Iterator<GlobalTablePartitionState>> globalTablePartitionStatesAsync(DisasterRecoveryManager manager) {
        return manager.globalTablePartitionStates(Set.of(), Set.of()).thenApply(states -> states.values().stream().sorted(GLOBAL_TABLE_PARTITION_STATE_COMPARATOR).iterator());
    }

    private static CompletableFuture<Iterator<SystemViewLocalTablePartitionState>> localTablePartitionStatesAsync(DisasterRecoveryManager manager) {
        return manager.localTablePartitionStates(Set.of(), Set.of(), Set.of()).thenApply(states -> states.values().stream().flatMap(statesByNodeName -> statesByNodeName.entrySet().stream()).map(nodeStates -> new SystemViewLocalTablePartitionState((String)nodeStates.getKey(), (LocalTablePartitionState)nodeStates.getValue())).sorted(SYSTEM_VIEW_LOCAL_PARTITION_STATE_COMPARATOR).iterator());
    }

    private static CompletableFuture<Iterator<GlobalPartitionState>> globalZonePartitionStatesAsync(DisasterRecoveryManager manager) {
        return manager.globalPartitionStates(Set.of(), Set.of()).thenApply(states -> states.values().stream().sorted(GLOBAL_ZONE_PARTITION_STATE_COMPARATOR).iterator());
    }

    private static CompletableFuture<Iterator<SystemViewLocalZonePartitionState>> localZonePartitionStatesAsync(DisasterRecoveryManager manager) {
        return manager.localPartitionStates(Set.of(), Set.of(), Set.of()).thenApply(states -> states.values().stream().flatMap(statesByNodeName -> statesByNodeName.entrySet().stream()).map(nodeStates -> new SystemViewLocalZonePartitionState((String)nodeStates.getKey(), (LocalPartitionState)nodeStates.getValue())).sorted(SYSTEM_VIEW_LOCAL_ZONE_PARTITION_STATE_COMPARATOR).iterator());
    }

    private static class SystemViewLocalZonePartitionState {
        private final String nodeName;
        private final LocalPartitionState state;

        private SystemViewLocalZonePartitionState(String nodeName, LocalPartitionState state) {
            this.nodeName = nodeName;
            this.state = state;
        }
    }

    private static class SystemViewLocalTablePartitionState {
        private final String nodeName;
        private final LocalTablePartitionState state;

        private SystemViewLocalTablePartitionState(String nodeName, LocalTablePartitionState state) {
            this.nodeName = nodeName;
            this.state = state;
        }
    }

    private static class SystemViewSubscription<T>
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final CompletableFuture<Iterator<T>> invokeApiFuture;
        private volatile boolean complete;

        private SystemViewSubscription(Flow.Subscriber<? super T> subscriber, CompletableFuture<Iterator<T>> invokeApiFuture) {
            this.subscriber = subscriber;
            this.invokeApiFuture = invokeApiFuture;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException("Must be positive: " + n));
                return;
            }
            if (this.complete) {
                return;
            }
            this.invokeApiFuture.whenComplete((iterator, throwable) -> {
                if (throwable != null) {
                    this.onError((Throwable)throwable);
                } else {
                    this.drain((Iterator<T>)iterator, n);
                }
            });
        }

        @Override
        public void cancel() {
            this.complete = true;
        }

        private void onError(Throwable t) {
            this.cancel();
            this.subscriber.onError(t);
        }

        private void drain(Iterator<T> iterator, long n) {
            if (this.complete) {
                return;
            }
            while (iterator.hasNext() && n-- > 0L) {
                this.subscriber.onNext(iterator.next());
            }
            if (!iterator.hasNext()) {
                this.complete = true;
                this.subscriber.onComplete();
            }
        }
    }
}

