/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.bifromq.basekv.store.wal;

import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.raft.proto.LogEntry;

public interface IKVRangeWALSubscriber {
    default void onSubscribe(IKVRangeWALSubscription subscription) {

    }

    /**
     * Callback method to apply log.
     *
     * @param log the committed log
     * @param isLeader if the node was leader when the log committed
     * @return the future to indicate when the log has been applied
     */
    CompletableFuture<Void> apply(LogEntry log, boolean isLeader);

    /**
     * Install snapshot to kv range asynchronously and the returned snapshot will be used for WAL compaction.
     *
     * @param requested the snapshot requested to be installed
     * @param leader    the leader
     * @param callback  the callback to notify the result of snapshot installation
     */
    CompletableFuture<Void> restore(KVRangeSnapshot requested, String leader, IAfterRestoredCallback callback);

    /**
     * Callback after snapshot restored.
     */
    interface IAfterRestoredCallback {
        CompletableFuture<Void> call(KVRangeSnapshot snapshot, Throwable ex);
    }
}
