/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basehookloader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseHookLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseHookLoader.class);
    private static final Map<Class<?>, Map<String, ?>> LOADED = new ConcurrentHashMap();

    public static <T> Map<String, T> load(Class<T> hookInterface) {
        return LOADED.computeIfAbsent(hookInterface, k -> {
            HashMap loadedFactories = new HashMap();
            ServiceLoader serviceLoader = ServiceLoader.load(hookInterface);
            Iterator iterator = serviceLoader.iterator();
            iterator.forEachRemaining(factoryImpl -> {
                String className = factoryImpl.getClass().getName();
                if (className.trim().isEmpty()) {
                    throw new IllegalStateException("Anonymous implementation is not allowed");
                }
                log.debug("Loaded {} implementation: {}", (Object)hookInterface.getSimpleName(), (Object)className);
                if (loadedFactories.putIfAbsent(className, factoryImpl) != null) {
                    throw new IllegalStateException("More than one implementations using same name " + className);
                }
            });
            return loadedFactories;
        });
    }

    @Generated
    private BaseHookLoader() {
    }
}

