/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.schema.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Interner;
import com.google.protobuf.ByteString;
import org.apache.bifromq.dist.worker.schema.KVSchemaConstants;
import org.apache.bifromq.dist.worker.schema.cache.RouteDetail;
import org.apache.bifromq.type.RouteMatcher;
import org.apache.bifromq.util.BSUtil;
import org.apache.bifromq.util.TopicUtil;

public class RouteDetailCache {
    private static final Interner<ByteString> ROUTE_KEY_INTERNER = Interner.newWeakInterner();
    private static final Interner<String> TENANTID_INTERNER = Interner.newWeakInterner();
    private static final Interner<String> MQTT_TOPICFILTER__INTERNER = Interner.newWeakInterner();
    private static final Interner<RouteMatcher> ROUTE_MATCHER_INTERNER = Interner.newWeakInterner();
    private static final Cache<String, RouteMatcher> ROUTE_MATCHER_CACHE = Caffeine.newBuilder().weakKeys().weakValues().build();
    private static final Cache<ByteString, RouteDetail> ROUTE_DETAIL_CACHE = Caffeine.newBuilder().weakKeys().weakValues().build();

    public static RouteDetail get(ByteString routeKey) {
        return (RouteDetail)ROUTE_DETAIL_CACHE.get((Object)((ByteString)ROUTE_KEY_INTERNER.intern((Object)routeKey)), k -> {
            short tenantIdLen = RouteDetailCache.tenantIdLen(k);
            int tenantIdStartIdx = KVSchemaConstants.SCHEMA_VER.size() + 2;
            int escapedTopicFilterStartIdx = tenantIdStartIdx + tenantIdLen;
            short receiverBytesLen = RouteDetailCache.receiverBytesLen(k);
            int receiverBytesStartIdx = k.size() - 2 - receiverBytesLen;
            int receiverBytesEndIdx = k.size() - 2;
            int flagByteIdx = receiverBytesStartIdx - 1;
            int separatorBytesIdx = flagByteIdx - 1 - 2;
            String receiverInfo = k.substring(receiverBytesStartIdx, receiverBytesEndIdx).toStringUtf8();
            byte flag = k.byteAt(flagByteIdx);
            String tenantId = (String)TENANTID_INTERNER.intern((Object)k.substring(tenantIdStartIdx, escapedTopicFilterStartIdx).toStringUtf8());
            String escapedTopicFilter = k.substring(escapedTopicFilterStartIdx, separatorBytesIdx).toStringUtf8();
            switch (flag) {
                case 1: {
                    String mqttTopicFilter = TopicUtil.unescape((String)escapedTopicFilter);
                    RouteMatcher matcher = (RouteMatcher)ROUTE_MATCHER_CACHE.get((Object)((String)MQTT_TOPICFILTER__INTERNER.intern((Object)mqttTopicFilter)), t -> (RouteMatcher)ROUTE_MATCHER_INTERNER.intern((Object)RouteMatcher.newBuilder().setType(RouteMatcher.Type.Normal).addAllFilterLevel((Iterable)TopicUtil.parse((String)escapedTopicFilter, (boolean)true)).setMqttTopicFilter(t).build()));
                    return new RouteDetail(tenantId, matcher, receiverInfo);
                }
                case 2: {
                    String mqttTopicFilter = "$share/" + receiverInfo + "/" + TopicUtil.unescape((String)escapedTopicFilter);
                    RouteMatcher matcher = (RouteMatcher)ROUTE_MATCHER_CACHE.get((Object)((String)MQTT_TOPICFILTER__INTERNER.intern((Object)mqttTopicFilter)), t -> (RouteMatcher)ROUTE_MATCHER_INTERNER.intern((Object)RouteMatcher.newBuilder().setType(RouteMatcher.Type.UnorderedShare).addAllFilterLevel((Iterable)TopicUtil.parse((String)escapedTopicFilter, (boolean)true)).setGroup(receiverInfo).setMqttTopicFilter(t).build()));
                    return new RouteDetail(tenantId, matcher, null);
                }
                case 3: {
                    String mqttTopicFilter = "$oshare/" + receiverInfo + "/" + TopicUtil.unescape((String)escapedTopicFilter);
                    RouteMatcher matcher = (RouteMatcher)ROUTE_MATCHER_CACHE.get((Object)((String)MQTT_TOPICFILTER__INTERNER.intern((Object)mqttTopicFilter)), t -> (RouteMatcher)ROUTE_MATCHER_INTERNER.intern((Object)RouteMatcher.newBuilder().setType(RouteMatcher.Type.OrderedShare).addAllFilterLevel((Iterable)TopicUtil.parse((String)escapedTopicFilter, (boolean)true)).setGroup(receiverInfo).setMqttTopicFilter(t).build()));
                    return new RouteDetail(tenantId, matcher, null);
                }
            }
            throw new UnsupportedOperationException("Unknown route type: " + flag);
        });
    }

    public static short tenantIdLen(ByteString routeKey) {
        return BSUtil.toShort((ByteString)routeKey.substring(KVSchemaConstants.SCHEMA_VER.size(), KVSchemaConstants.SCHEMA_VER.size() + 2));
    }

    public static short receiverBytesLen(ByteString routeKey) {
        return BSUtil.toShort((ByteString)routeKey.substring(routeKey.size() - 2));
    }

    static void drainCaches() {
        ROUTE_MATCHER_CACHE.cleanUp();
        ROUTE_DETAIL_CACHE.cleanUp();
    }

    static long routeMatcherCacheSize() {
        return ROUTE_MATCHER_CACHE.estimatedSize();
    }
}

