/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.handler;

import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.dist.rpc.proto.UnmatchReply;
import org.apache.bifromq.dist.rpc.proto.UnmatchRequest;
import org.apache.bifromq.dist.server.handler.IDistServiceReqHandler;
import org.apache.bifromq.dist.server.scheduler.IUnmatchCallScheduler;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.distservice.UnmatchError;
import org.apache.bifromq.plugin.eventcollector.distservice.Unmatched;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmatchReqHandler
implements IDistServiceReqHandler<UnmatchRequest, UnmatchReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnmatchReqHandler.class);
    private final IEventCollector eventCollector;
    private final IUnmatchCallScheduler unmatchCallScheduler;

    public UnmatchReqHandler(IEventCollector eventCollector, IUnmatchCallScheduler unmatchCallScheduler) {
        this.eventCollector = eventCollector;
        this.unmatchCallScheduler = unmatchCallScheduler;
    }

    @Override
    public CompletableFuture<UnmatchReply> handle(UnmatchRequest request) {
        return this.unmatchCallScheduler.schedule(request).handle(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                log.debug("Failed to exec UnsubRequest, tenantId={}, req={}", new Object[]{request.getTenantId(), request, e});
                this.eventCollector.report((Event)((UnmatchError)ThreadLocalEventPool.getLocal(UnmatchError.class)).reqId(request.getReqId()).tenantId(request.getTenantId()).topicFilter(request.getMatcher().getMqttTopicFilter()).receiverId(request.getReceiverId()).subBrokerId(request.getBrokerId()).delivererKey(request.getDelivererKey()).reason(e.getMessage()));
                if (e instanceof BackPressureException) {
                    return UnmatchReply.newBuilder().setReqId(request.getReqId()).setResult(UnmatchReply.Result.BACK_PRESSURE_REJECTED).build();
                }
                return UnmatchReply.newBuilder().setReqId(request.getReqId()).setResult(UnmatchReply.Result.ERROR).build();
            }
            if (v.getResult() == UnmatchReply.Result.OK) {
                this.eventCollector.report((Event)((Unmatched)ThreadLocalEventPool.getLocal(Unmatched.class)).reqId(request.getReqId()).tenantId(request.getTenantId()).topicFilter(request.getMatcher().getMqttTopicFilter()).receiverId(request.getReceiverId()).subBrokerId(request.getBrokerId()).delivererKey(request.getDelivererKey()));
            } else {
                this.eventCollector.report((Event)((UnmatchError)ThreadLocalEventPool.getLocal(UnmatchError.class)).reqId(request.getReqId()).tenantId(request.getTenantId()).topicFilter(request.getMatcher().getMqttTopicFilter()).receiverId(request.getReceiverId()).subBrokerId(request.getBrokerId()).delivererKey(request.getDelivererKey()).reason("Internal Error"));
            }
            return v;
        }));
    }

    @Override
    public void close() {
        this.unmatchCallScheduler.close();
    }
}

