/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.inbox.util;

import org.apache.bifromq.sysprops.props.DeliverersPerMqttServer;

public class DelivererKeyUtil {
    private static final String DELIMITER = ":";
    private static final int MAX_DELIVERER_NUM = (Integer)DeliverersPerMqttServer.INSTANCE.get();

    public static String toDelivererKey(String tenantId, String inboxId, String serverId) {
        assert (!serverId.contains(DELIMITER)) : "serverId SHOULD NOT contain ':'";
        return serverId + DELIMITER + tenantId + DELIMITER + DelivererKeyUtil.groupIdx(inboxId);
    }

    public static String parseTenantId(String delivererKey) {
        int firstIdx = delivererKey.indexOf(DELIMITER);
        int secondIdx = delivererKey.lastIndexOf(DELIMITER);
        return delivererKey.substring(firstIdx + 1, secondIdx);
    }

    public static String parseServerId(String delivererKey) {
        return delivererKey.substring(0, delivererKey.indexOf(DELIMITER));
    }

    private static int groupIdx(String inboxId) {
        int idx = inboxId.hashCode() % MAX_DELIVERER_NUM;
        if (idx < 0) {
            idx = (idx + MAX_DELIVERER_NUM) % MAX_DELIVERER_NUM;
        }
        return idx;
    }
}

